/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiErrorElement;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.DiagnosticCheckerFilter;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnosticList;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnostics;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.element.builder.FirElementBuilderKt;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DeclarationStructureElement;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileElementFactory;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructure;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.RootStructureElement;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.util.DeclarationUtilsKt;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.util.ExceptionUtilsKt;
import ksp.org.jetbrains.kotlin.diagnostics.KtPsiDiagnostic;
import ksp.org.jetbrains.kotlin.fir.ClassMembersKt;
import ksp.org.jetbrains.kotlin.fir.FirFileAnnotationsContainer;
import ksp.org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirProperty;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import ksp.org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import ksp.org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import ksp.org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import ksp.org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import ksp.org.jetbrains.kotlin.psi.KtClassOrObject;
import ksp.org.jetbrains.kotlin.psi.KtCodeFragment;
import ksp.org.jetbrains.kotlin.psi.KtDeclaration;
import ksp.org.jetbrains.kotlin.psi.KtElement;
import ksp.org.jetbrains.kotlin.psi.KtFile;
import ksp.org.jetbrains.kotlin.psi.KtModifierList;
import ksp.org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import ksp.org.jetbrains.kotlin.psi.KtScript;
import ksp.org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import ksp.org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import ksp.org.jetbrains.kotlin.psi.KtTypeReference;
import ksp.org.jetbrains.kotlin.psi.KtVisitorVoid;
import ksp.org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import ksp.org.jetbrains.kotlin.utils.exceptions.ExceptionAttachementBuilderUtilsKt;
import ksp.org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import ksp.org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import ksp.org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 (2\u00020\u0001:\u0001(B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001cJ\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u000e\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\rJ\u0012\u0010 \u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001e\u001a\u00020\rH\u0002J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\rJ(\u0010#\u001a\u00020\"*\b\u0012\u0004\u0012\u00020\u00180$2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010%\u001a\u00020&*\u00020'2\u0006\u0010\u001e\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "", "ktFile", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "firFile", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "moduleComponents", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;)V", "firProvider", "Lksp/org/jetbrains/kotlin/fir/resolve/providers/FirProvider;", "structureElements", "Ljava/util/concurrent/ConcurrentHashMap;", "Lksp/org/jetbrains/kotlin/psi/KtElement;", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "createDanglingModifierListStructure", "container", "Lksp/org/jetbrains/kotlin/psi/KtModifierList;", "createDeclarationStructure", "declaration", "Lksp/org/jetbrains/kotlin/psi/KtDeclaration;", "createStructureElement", "getAllDiagnosticsForFile", "", "Lksp/org/jetbrains/kotlin/diagnostics/KtPsiDiagnostic;", "diagnosticCheckerFilter", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/api/DiagnosticCheckerFilter;", "getAllStructureElements", "", "getContainerKtElement", "element", "getStructureElementFor", "getStructureKtElement", "invalidateElement", "", "collectDiagnosticsFromStructureElements", "", "isPartOfSuperClassCall", "", "Lksp/org/jetbrains/kotlin/psi/KtClassOrObject;", "Companion", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nFileStructure.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileStructure.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FileStructureElementDiagnostics.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnostics\n+ 6 FileStructureElementDiagnosticList.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/diagnostics/FileStructureElementDiagnosticList\n+ 7 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n*L\n1#1,216:1\n72#2,2:217\n1#3:219\n1853#4:220\n1853#4,2:224\n1854#4:230\n1853#4,2:231\n40#5,2:221\n43#5,4:226\n16#6:223\n81#7,7:233\n76#7,2:240\n57#7:242\n78#7:243\n*S KotlinDebug\n*F\n+ 1 FileStructure.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure\n*L\n67#1:217,2\n67#1:219\n128#1:220\n129#1:224,2\n128#1:230\n171#1:231,2\n129#1:221,2\n129#1:226,4\n129#1:223\n211#1:233,7\n211#1:240,2\n211#1:242\n211#1:243\n*E\n"})
public final class FileStructure {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KtFile ktFile;
    @NotNull
    private final FirFile firFile;
    @NotNull
    private final LLFirModuleResolveComponents moduleComponents;
    @NotNull
    private final FirProvider firProvider;
    @NotNull
    private final ConcurrentHashMap<KtElement, FileStructureElement> structureElements;

    private FileStructure(KtFile ktFile, FirFile firFile, LLFirModuleResolveComponents moduleComponents) {
        this.ktFile = ktFile;
        this.firFile = firFile;
        this.moduleComponents = moduleComponents;
        this.firProvider = FirProviderKt.getFirProvider(this.firFile.getModuleData().getSession());
        this.structureElements = new ConcurrentHashMap();
    }

    public final void invalidateElement(@NotNull KtElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        KtElement container2 = this.getContainerKtElement(element2);
        this.structureElements.remove(container2);
    }

    @NotNull
    public final FileStructureElement getStructureElementFor(@NotNull KtElement element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        KtElement container2 = this.getContainerKtElement(element2);
        ConcurrentMap $this$getOrPut$iv = this.structureElements;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(container2);
        if (object == null) {
            boolean bl = false;
            FileStructureElement default$iv = this.createStructureElement(container2);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(container2, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        return (FileStructureElement)object;
    }

    private final KtElement getContainerKtElement(KtElement element2) {
        KtDeclaration declaration2 = this.getStructureKtElement(element2);
        KtElement container2 = null;
        if (declaration2 != null) {
            container2 = declaration2;
        } else {
            KtElement ktElement;
            KtModifierList modifierList2 = PsiTreeUtil.getParentOfType((PsiElement)element2, KtModifierList.class, false);
            if (modifierList2 != null && PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(modifierList2, false, 1, null) instanceof PsiErrorElement) {
                ktElement = modifierList2;
            } else {
                KtFile ktFile = element2.getContainingKtFile();
                Intrinsics.checkNotNull((Object)ktFile);
                ktElement = ktFile;
            }
            container2 = ktElement;
        }
        return container2;
    }

    private final KtDeclaration getStructureKtElement(KtElement element2) {
        KtPrimaryConstructor resultedContainer;
        KtDeclaration container2 = FirElementBuilderKt.getNonLocalContainingOrThisDeclaration(element2, (Function1<? super KtDeclaration, Boolean>)((Function1)getStructureKtElement.container.1.INSTANCE));
        KtPrimaryConstructor ktPrimaryConstructor = resultedContainer = container2 instanceof KtClassOrObject && this.isPartOfSuperClassCall((KtClassOrObject)container2, element2) ? ((KtClassOrObject)container2).getPrimaryConstructor() : null;
        return ktPrimaryConstructor != null ? (KtDeclaration)ktPrimaryConstructor : container2;
    }

    private final boolean isPartOfSuperClassCall(KtClassOrObject $this$isPartOfSuperClassCall, KtElement element2) {
        for (KtSuperTypeListEntry entry : $this$isPartOfSuperClassCall.getSuperTypeListEntries()) {
            boolean typeReferenceIsAncestor;
            if (!(entry instanceof KtSuperTypeCallEntry)) continue;
            KtTypeReference ktTypeReference = ((KtSuperTypeCallEntry)entry).getCalleeExpression().getTypeReference();
            boolean bl = ktTypeReference != null ? PsiUtilsKt.isAncestor(ktTypeReference, element2, false) : (typeReferenceIsAncestor = false);
            if (typeReferenceIsAncestor) {
                return false;
            }
            if (!PsiUtilsKt.isAncestor(entry, element2, false)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final List<KtPsiDiagnostic> getAllDiagnosticsForFile(@NotNull DiagnosticCheckerFilter diagnosticCheckerFilter) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)((Object)diagnosticCheckerFilter), (String)"diagnosticCheckerFilter");
        Collection<FileStructureElement> structureElements = this.getAllStructureElements();
        List $this$getAllDiagnosticsForFile_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        this.collectDiagnosticsFromStructureElements($this$getAllDiagnosticsForFile_u24lambda_u241, structureElements, diagnosticCheckerFilter);
        return CollectionsKt.build((List)list2);
    }

    private final void collectDiagnosticsFromStructureElements(Collection<KtPsiDiagnostic> $this$collectDiagnosticsFromStructureElements, Collection<? extends FileStructureElement> structureElements, DiagnosticCheckerFilter diagnosticCheckerFilter) {
        Iterable $this$forEach$iv = structureElements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            List diagnostics2;
            boolean $i$f$forEach2;
            Iterable $this$forEach$iv$iv$iv;
            boolean $i$f$forEach3;
            FileStructureElementDiagnosticList this_$iv$iv;
            FileStructureElement structureElement = (FileStructureElement)element$iv;
            boolean bl2 = false;
            FileStructureElementDiagnostics this_$iv = structureElement.getDiagnostics();
            boolean $i$f$forEach4 = false;
            if (diagnosticCheckerFilter.getRunCommonCheckers()) {
                this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByCommonCheckers(this_$iv);
                $i$f$forEach3 = false;
                $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
                $i$f$forEach2 = false;
                for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                    diagnostics2 = (List)element$iv$iv$iv;
                    bl = false;
                    $this$collectDiagnosticsFromStructureElements.addAll(diagnostics2);
                }
            }
            if (!diagnosticCheckerFilter.getRunExtendedCheckers()) continue;
            this_$iv$iv = FileStructureElementDiagnostics.access$getDiagnosticByExtendedCheckers(this_$iv);
            $i$f$forEach3 = false;
            $this$forEach$iv$iv$iv = FileStructureElementDiagnosticList.access$getMap$p(this_$iv$iv).values();
            $i$f$forEach2 = false;
            for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                diagnostics2 = (List)element$iv$iv$iv;
                bl = false;
                $this$collectDiagnosticsFromStructureElements.addAll(diagnostics2);
            }
        }
    }

    @NotNull
    public final Collection<FileStructureElement> getAllStructureElements() {
        Object[] objectArray = new FileStructureElement[]{this.getStructureElementFor(this.ktFile)};
        Set structureElements = SetsKt.mutableSetOf((Object[])objectArray);
        this.ktFile.accept(new KtVisitorVoid(this, structureElements){
            final /* synthetic */ FileStructure this$0;
            final /* synthetic */ Set<FileStructureElement> $structureElements;
            {
                this.this$0 = $receiver;
                this.$structureElements = $structureElements;
            }

            public void visitElement(PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                element2.acceptChildren(this);
            }

            public void visitDeclaration(KtDeclaration dcl) {
                boolean canHaveInnerStructure;
                Intrinsics.checkNotNullParameter((Object)dcl, (String)"dcl");
                FileStructureElement structureElement = this.this$0.getStructureElementFor(dcl);
                ((Collection)this.$structureElements).add(structureElement);
                boolean bl = canHaveInnerStructure = dcl instanceof KtClassOrObject || dcl instanceof KtScript;
                if (canHaveInnerStructure) {
                    dcl.acceptChildren(this);
                }
            }

            public void visitModifierList(KtModifierList list2) {
                Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
                if (Intrinsics.areEqual((Object)list2.getParent(), (Object)FileStructure.access$getKtFile$p(this.this$0))) {
                    ((Collection)this.$structureElements).add(this.this$0.getStructureElementFor(list2));
                }
            }
        });
        return CollectionsKt.asReversed((List)CollectionsKt.toList((Iterable)structureElements));
    }

    private final FileStructureElement createDeclarationStructure(KtDeclaration declaration2) {
        FirDeclaration firDeclaration = DeclarationUtilsKt.findSourceNonLocalFirDeclaration(declaration2, this.firFile, this.firProvider);
        FirLazyDeclarationResolverKt.lazyResolveToPhase(firDeclaration, FirResolvePhase.BODY_RESOLVE);
        if (firDeclaration instanceof FirPrimaryConstructor) {
            Iterable $this$forEach$iv = ((FirPrimaryConstructor)firDeclaration).getValueParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirValueParameter parameter2 = (FirValueParameter)element$iv;
                boolean bl = false;
                FirProperty firProperty = ClassMembersKt.getCorrespondingProperty(parameter2);
                if (firProperty != null) {
                    FirLazyDeclarationResolverKt.lazyResolveToPhase(firProperty, FirResolvePhase.BODY_RESOLVE);
                }
            }
        }
        return FileElementFactory.INSTANCE.createFileStructureElement(firDeclaration, this.firFile, this.moduleComponents);
    }

    private final FileStructureElement createDanglingModifierListStructure(KtModifierList container2) {
        FirDeclaration firDeclaration = DeclarationUtilsKt.findSourceByTraversingWholeTree(container2, this.moduleComponents.getFirFileBuilder(), this.firFile);
        FirDanglingModifierList firDanglingModifierList = firDeclaration instanceof FirDanglingModifierList ? (FirDanglingModifierList)firDeclaration : null;
        if (firDanglingModifierList == null) {
            ExceptionUtilsKt.errorWithFirSpecificEntries$default("No dangling modifier found", null, null, null, container2, null, 46, null);
            throw null;
        }
        FirDanglingModifierList firDanglingModifierList2 = firDanglingModifierList;
        FirLazyDeclarationResolverKt.lazyResolveToPhase(firDanglingModifierList2, FirResolvePhase.BODY_RESOLVE);
        return new DeclarationStructureElement(this.firFile, firDanglingModifierList2, this.moduleComponents);
    }

    /*
     * WARNING - void declaration
     */
    private final FileStructureElement createStructureElement(KtElement container2) {
        FileStructureElement fileStructureElement;
        if (container2 instanceof KtCodeFragment) {
            FirCodeFragment firCodeFragment = DeclarationUtilsKt.getCodeFragment(this.firFile);
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firCodeFragment, FirResolvePhase.BODY_RESOLVE);
            fileStructureElement = new DeclarationStructureElement(this.firFile, firCodeFragment, this.moduleComponents);
        } else if (container2 instanceof KtFile) {
            FirFile firFile = this.moduleComponents.getFirFileBuilder().buildRawFirFileWithCaching(this.ktFile);
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firFile, FirResolvePhase.IMPORTS);
            FirFileAnnotationsContainer firFileAnnotationsContainer = firFile.getAnnotationsContainer();
            if (firFileAnnotationsContainer != null) {
                FirLazyDeclarationResolverKt.lazyResolveToPhase(firFileAnnotationsContainer, FirResolvePhase.BODY_RESOLVE);
            }
            fileStructureElement = new RootStructureElement(firFile, this.moduleComponents);
        } else if (container2 instanceof KtDeclaration) {
            fileStructureElement = this.createDeclarationStructure((KtDeclaration)container2);
        } else if (container2 instanceof KtModifierList && PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments$default(container2, false, 1, null) instanceof PsiErrorElement) {
            fileStructureElement = this.createDanglingModifierListStructure((KtModifierList)container2);
        } else {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            String message$iv = "Invalid container " + Reflection.getOrCreateKotlinClass(container2.getClass());
            Throwable cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            void $this$createStructureElement_u24lambda_u245 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            ExceptionAttachementBuilderUtilsKt.withPsiEntry((ExceptionAttachmentBuilder)$this$createStructureElement_u24lambda_u245, "container", container2);
            kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        return fileStructureElement;
    }

    public /* synthetic */ FileStructure(KtFile ktFile, FirFile firFile, LLFirModuleResolveComponents moduleComponents, DefaultConstructorMarker $constructor_marker) {
        this(ktFile, firFile, moduleComponents);
    }

    public static final /* synthetic */ KtFile access$getKtFile$p(FileStructure $this) {
        return $this.ktFile;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure$Companion;", "", "()V", "build", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructure;", "ktFile", "Lksp/org/jetbrains/kotlin/psi/KtFile;", "moduleComponents", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "low-level-api-fir"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FileStructure build(@NotNull KtFile ktFile, @NotNull LLFirModuleResolveComponents moduleComponents) {
            Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
            Intrinsics.checkNotNullParameter((Object)moduleComponents, (String)"moduleComponents");
            FirFile firFile = moduleComponents.getFirFileBuilder().buildRawFirFileWithCaching(ktFile);
            return new FileStructure(ktFile, firFile, moduleComponents, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

