/*
 * Decompiled with CFR 0.152.
 */
package ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.kotlin.KtFakeSourceElementKind;
import ksp.org.jetbrains.kotlin.KtSourceElement;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignation;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationKt;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.LLFirClassWithSpecificMembersResolveTarget;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.TargetUtilsKt;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnosticRetrieverKt;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.ClassDeclarationStructureElement;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DeclarationStructureElement;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import ksp.org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.RootScriptStructureElement;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import ksp.org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import ksp.org.jetbrains.kotlin.fir.declarations.FirField;
import ksp.org.jetbrains.kotlin.fir.declarations.FirFile;
import ksp.org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import ksp.org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import ksp.org.jetbrains.kotlin.fir.declarations.FirScript;
import ksp.org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileElementFactory;", "", "()V", "createFileStructureElement", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "firDeclaration", "Lksp/org/jetbrains/kotlin/fir/declarations/FirDeclaration;", "firFile", "Lksp/org/jetbrains/kotlin/fir/declarations/FirFile;", "moduleComponents", "Lksp/org/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "lazyResolveClassWithGeneratedMembers", "", "firClass", "Lksp/org/jetbrains/kotlin/fir/declarations/FirRegularClass;", "low-level-api-fir"})
public final class FileElementFactory {
    @NotNull
    public static final FileElementFactory INSTANCE = new FileElementFactory();

    private FileElementFactory() {
    }

    @NotNull
    public final FileStructureElement createFileStructureElement(@NotNull FirDeclaration firDeclaration, @NotNull FirFile firFile, @NotNull LLFirModuleResolveComponents moduleComponents) {
        FileStructureElement fileStructureElement;
        Intrinsics.checkNotNullParameter((Object)firDeclaration, (String)"firDeclaration");
        Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
        Intrinsics.checkNotNullParameter((Object)moduleComponents, (String)"moduleComponents");
        if (firDeclaration instanceof FirRegularClass) {
            this.lazyResolveClassWithGeneratedMembers((FirRegularClass)firDeclaration);
            fileStructureElement = new ClassDeclarationStructureElement(firFile, (FirRegularClass)firDeclaration, moduleComponents);
        } else {
            fileStructureElement = firDeclaration instanceof FirScript ? (FileStructureElement)new RootScriptStructureElement(firFile, (FirScript)firDeclaration, moduleComponents) : (FileStructureElement)new DeclarationStructureElement(firFile, firDeclaration, moduleComponents);
        }
        return fileStructureElement;
    }

    private final void lazyResolveClassWithGeneratedMembers(FirRegularClass firClass) {
        List list2;
        List $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (FirDeclaration member2 : firClass.getDeclarations()) {
            if (member2 instanceof FirSimpleFunction) {
                KtSourceElement ktSourceElement = member2.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) {
                    $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member2);
                    continue;
                }
            }
            KtSourceElement ktSourceElement = member2.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumGeneratedDeclaration.INSTANCE)) {
                $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member2);
                continue;
            }
            if (FileStructureElementDiagnosticRetrieverKt.isImplicitConstructor(member2)) {
                $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member2);
                continue;
            }
            if (member2 instanceof FirField) {
                KtSourceElement ktSourceElement2 = member2.getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.ClassDelegationField.INSTANCE)) {
                    $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member2);
                    continue;
                }
            }
            if (!(member2 instanceof FirDanglingModifierList)) continue;
            $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member2);
        }
        List classMembersToResolve = CollectionsKt.build((List)list2);
        FirDesignation firClassDesignation = FirDesignationKt.collectDesignation$default(firClass, null, 1, null);
        LLFirClassWithSpecificMembersResolveTarget designationWithMembers = new LLFirClassWithSpecificMembersResolveTarget(firClassDesignation, classMembersToResolve);
        TargetUtilsKt.resolve(designationWithMembers, FirResolvePhase.BODY_RESOLVE);
    }
}

