/*
 * Decompiled with CFR 0.152.
 */
package ksp.one.util.streamex;

import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import ksp.one.util.streamex.Internals;

abstract class PrefixOps<T, S extends Spliterator<T>>
extends Internals.CloneableSpliterator<T, PrefixOps<T, S>> {
    private static final int BUF_SIZE = 128;
    S source;
    AtomicReference<T> accRef;
    T acc = Internals.none();
    int idx = 0;
    final BinaryOperator<T> op;

    PrefixOps(S source, BinaryOperator<T> op) {
        this.source = source;
        this.op = op;
    }

    @Override
    public Spliterator<T> trySplit() {
        if (this.acc != Internals.NONE) {
            return null;
        }
        Spliterator prefix = this.source.trySplit();
        if (prefix == null) {
            return null;
        }
        if (this.accRef == null) {
            this.accRef = new AtomicReference(Internals.none());
        }
        PrefixOps pref = (PrefixOps)this.doClone();
        pref.source = prefix;
        return pref;
    }

    @Override
    public long estimateSize() {
        return this.source.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0x5450;
    }

    static final class OfUnordRef<T>
    extends PrefixOps<T, Spliterator<T>>
    implements Consumer<T> {
        private final BinaryOperator<T> localOp;

        OfUnordRef(Spliterator<T> source, BinaryOperator<T> op) {
            super(source, (a, b) -> a == Internals.NONE ? b : op.apply(a, b));
            this.localOp = op;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            if (this.accRef == null) {
                this.source.forEachRemaining(next -> {
                    this.acc = this.op.apply(this.acc, next);
                    action.accept(this.acc);
                });
            } else {
                Object[] buf = new Object[128];
                this.source.forEachRemaining(next -> {
                    if (this.idx == 0) {
                        buf[this.idx++] = next;
                    } else {
                        Object prev = buf[this.idx - 1];
                        buf[this.idx++] = this.localOp.apply(prev, next);
                        if (this.idx == buf.length) {
                            this.drain(action, buf);
                            this.idx = 0;
                        }
                    }
                });
                if (this.idx > 0) {
                    this.drain(action, buf);
                }
            }
        }

        private void drain(Consumer<? super T> action, T[] buf) {
            T last = buf[this.idx - 1];
            T acc = this.accRef.getAndAccumulate(last, this.op);
            if (acc != Internals.NONE) {
                for (int i = 0; i < this.idx; ++i) {
                    action.accept(this.localOp.apply(buf[i], acc));
                }
            } else {
                for (int i = 0; i < this.idx; ++i) {
                    action.accept(buf[i]);
                }
            }
        }

        @Override
        public void accept(T next) {
            this.acc = this.accRef == null ? this.op.apply(this.acc, next) : this.accRef.accumulateAndGet(next, this.op);
        }
    }

    static final class OfDouble
    extends Spliterators.AbstractDoubleSpliterator
    implements DoubleConsumer {
        private final DoubleBinaryOperator op;
        private final Spliterator.OfDouble source;
        private boolean started;
        private double acc;

        OfDouble(Spliterator.OfDouble source, DoubleBinaryOperator op) {
            super(source.estimateSize(), source.characteristics() & 0x1550);
            this.source = source;
            this.op = op;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer action) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(DoubleConsumer action) {
            this.source.forEachRemaining((double next) -> {
                this.accept(next);
                action.accept(this.acc);
            });
        }

        @Override
        public void accept(double next) {
            if (this.started) {
                this.acc = this.op.applyAsDouble(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }
    }

    static final class OfLong
    extends Spliterators.AbstractLongSpliterator
    implements LongConsumer {
        private final LongBinaryOperator op;
        private final Spliterator.OfLong source;
        private boolean started;
        private long acc;

        OfLong(Spliterator.OfLong source, LongBinaryOperator op) {
            super(source.estimateSize(), source.characteristics() & 0x1550);
            this.source = source;
            this.op = op;
        }

        @Override
        public boolean tryAdvance(LongConsumer action) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(LongConsumer action) {
            this.source.forEachRemaining((long next) -> {
                this.accept(next);
                action.accept(this.acc);
            });
        }

        @Override
        public void accept(long next) {
            if (this.started) {
                this.acc = this.op.applyAsLong(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }
    }

    static final class OfInt
    extends Spliterators.AbstractIntSpliterator
    implements IntConsumer {
        private final IntBinaryOperator op;
        private final Spliterator.OfInt source;
        private boolean started;
        private int acc;

        OfInt(Spliterator.OfInt source, IntBinaryOperator op) {
            super(source.estimateSize(), source.characteristics() & 0x1550);
            this.source = source;
            this.op = op;
        }

        @Override
        public boolean tryAdvance(IntConsumer action) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(IntConsumer action) {
            this.source.forEachRemaining((int next) -> {
                this.accept(next);
                action.accept(this.acc);
            });
        }

        @Override
        public void accept(int next) {
            if (this.started) {
                this.acc = this.op.applyAsInt(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }
    }

    static final class OfRef<T>
    extends Spliterators.AbstractSpliterator<T>
    implements Consumer<T> {
        private final BinaryOperator<T> op;
        private final Spliterator<T> source;
        private boolean started;
        private T acc;

        OfRef(Spliterator<T> source, BinaryOperator<T> op) {
            super(source.estimateSize(), source.characteristics() & 0x1450);
            this.source = source;
            this.op = op;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (!this.source.tryAdvance(this)) {
                return false;
            }
            action.accept(this.acc);
            return true;
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.source.forEachRemaining(next -> {
                this.accept(next);
                action.accept((T)this.acc);
            });
        }

        @Override
        public void accept(T next) {
            if (this.started) {
                this.acc = this.op.apply(this.acc, next);
            } else {
                this.started = true;
                this.acc = next;
            }
        }
    }
}

