/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.util.lang.fastutil;

final class Hash {
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_INITIAL_SIZE = 16;
    private static final int INT_PHI = -1640531527;
    private static final long LONG_PHI = -7046029254386353131L;

    Hash() {
    }

    public static int arraySize(int expected, float f) {
        long s = Math.max(2L, Hash.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }

    public static int nextPowerOfTwo(int x) {
        if (x == 0) {
            return 1;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        return (x | x >> 16) + 1;
    }

    public static int long2int(long l) {
        return (int)(l ^ l >>> 32);
    }

    public static long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1L;
    }

    public static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((float)n * f), n - 1);
    }

    public static int mix(int x) {
        int h = x * -1640531527;
        return h ^ h >>> 16;
    }

    public static long mix(long x) {
        long h = x * -7046029254386353131L;
        h ^= h >>> 32;
        return h ^ h >>> 16;
    }
}

