/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.scope;

import ksp.com.intellij.openapi.util.Key;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiExpression;
import ksp.com.intellij.psi.PsiInstanceOfExpression;
import ksp.com.intellij.psi.PsiParenthesizedExpression;
import ksp.com.intellij.psi.PsiPattern;
import ksp.com.intellij.psi.PsiPatternVariable;
import ksp.com.intellij.psi.PsiPolyadicExpression;
import ksp.com.intellij.psi.PsiPrefixExpression;
import ksp.com.intellij.psi.ResolveState;
import ksp.org.jetbrains.annotations.NotNull;

public enum PatternResolveState {
    WHEN_TRUE,
    WHEN_FALSE,
    WHEN_BOTH,
    WHEN_NONE;

    public static final Key<PatternResolveState> KEY;

    public static PatternResolveState fromBoolean(boolean value2) {
        return value2 ? WHEN_TRUE : WHEN_FALSE;
    }

    public PatternResolveState invert() {
        switch (this) {
            case WHEN_TRUE: {
                return WHEN_FALSE;
            }
            case WHEN_FALSE: {
                return WHEN_TRUE;
            }
        }
        return this;
    }

    public ResolveState putInto(ResolveState rs) {
        return rs.put(KEY, this);
    }

    @NotNull
    public static PatternResolveState stateAtParent(PsiPatternVariable element2, PsiExpression parent2) {
        PsiPattern pattern = element2.getPattern();
        PatternResolveState state = WHEN_TRUE;
        PsiElement prev = pattern;
        PsiElement current = prev.getParent();
        while (prev != parent2) {
            if (!(current instanceof PsiInstanceOfExpression || current instanceof PsiParenthesizedExpression || current instanceof PsiPolyadicExpression && (((PsiPolyadicExpression)current).getOperationTokenType() == JavaTokenType.ANDAND || ((PsiPolyadicExpression)current).getOperationTokenType() == JavaTokenType.OROR))) {
                if (current instanceof PsiPrefixExpression && ((PsiPrefixExpression)current).getOperationTokenType() == JavaTokenType.EXCL) {
                    state = state.invert();
                } else {
                    PatternResolveState patternResolveState = WHEN_NONE;
                    if (patternResolveState == null) {
                        PatternResolveState.$$$reportNull$$$0(0);
                    }
                    return patternResolveState;
                }
            }
            prev = current;
            current = current.getParent();
        }
        PatternResolveState patternResolveState = state;
        if (patternResolveState == null) {
            PatternResolveState.$$$reportNull$$$0(1);
        }
        return patternResolveState;
    }

    static {
        KEY = Key.create("JavaPatternDeclarationHint");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ksp/com/intellij/psi/scope/PatternResolveState", "stateAtParent"));
    }
}

