/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.vfs.newvfs.events;

import ksp.com.intellij.openapi.util.Comparing;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.VirtualFileSystem;
import ksp.com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;

public final class VFileMoveEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final VirtualFile myOldParent;
    private final VirtualFile myNewParent;

    public VFileMoveEvent(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) {
        if (file2 == null) {
            VFileMoveEvent.$$$reportNull$$$0(0);
        }
        if (newParent == null) {
            VFileMoveEvent.$$$reportNull$$$0(1);
        }
        super(requestor, false);
        this.myFile = file2;
        this.myNewParent = newParent;
        this.myOldParent = file2.getParent();
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            VFileMoveEvent.$$$reportNull$$$0(2);
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile getNewParent() {
        VirtualFile virtualFile2 = this.myNewParent;
        if (virtualFile2 == null) {
            VFileMoveEvent.$$$reportNull$$$0(3);
        }
        return virtualFile2;
    }

    public VirtualFile getOldParent() {
        return this.myOldParent;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[move " + this.myFile.getName() + " from " + this.myOldParent + " to " + this.myNewParent + "]";
    }

    @Override
    @NotNull
    public String getPath() {
        String string2 = this.computePath();
        if (string2 == null) {
            VFileMoveEvent.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @Override
    @NotNull
    protected String computePath() {
        String string2 = this.myFile.getPath();
        if (string2 == null) {
            VFileMoveEvent.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            VFileMoveEvent.$$$reportNull$$$0(6);
        }
        return virtualFileSystem;
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid() && Comparing.equal(this.myFile.getParent(), this.myOldParent) && this.myOldParent.isValid();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileMoveEvent event = (VFileMoveEvent)o;
        if (!this.myFile.equals(event.myFile)) {
            return false;
        }
        if (!this.myNewParent.equals(event.myNewParent)) {
            return false;
        }
        return this.myOldParent.equals(event.myOldParent);
    }

    @Override
    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + this.myOldParent.hashCode();
        result2 = 31 * result2 + this.myNewParent.hashCode();
        return result2;
    }

    @NotNull
    public String getOldPath() {
        String string2 = this.myOldParent.getPath() + "/" + this.myFile.getName();
        if (string2 == null) {
            VFileMoveEvent.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @NotNull
    public String getNewPath() {
        String string2 = this.myNewParent.getPath() + "/" + this.myFile.getName();
        if (string2 == null) {
            VFileMoveEvent.$$$reportNull$$$0(8);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/vfs/newvfs/events/VFileMoveEvent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewParent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computePath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getOldPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

