/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.vfs.impl;

import ksp.com.intellij.openapi.application.Application;
import ksp.com.intellij.openapi.application.ApplicationManager;
import ksp.com.intellij.openapi.vfs.StandardFileSystems;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.openapi.vfs.VirtualFileManager;
import ksp.com.intellij.openapi.vfs.VirtualFileSystem;
import ksp.com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import ksp.com.intellij.util.ObjectUtils;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class LightFilePointer
implements VirtualFilePointer {
    @NotNull
    private final String myUrl;
    @Nullable
    private volatile VirtualFile myFile;
    private volatile boolean myRefreshed;

    public LightFilePointer(@NotNull String url) {
        if (url == null) {
            LightFilePointer.$$$reportNull$$$0(0);
        }
        this.myUrl = url;
    }

    public LightFilePointer(@NotNull VirtualFile file2) {
        if (file2 == null) {
            LightFilePointer.$$$reportNull$$$0(1);
        }
        this.myUrl = file2.getUrl();
        this.myFile = file2;
    }

    @Override
    @Nullable
    public VirtualFile getFile() {
        this.refreshFile();
        return this.myFile;
    }

    @Override
    @NotNull
    public String getUrl() {
        String string2 = this.myUrl;
        if (string2 == null) {
            LightFilePointer.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getFileName() {
        VirtualFile file2 = this.myFile;
        if (file2 != null) {
            String string2 = file2.getName();
            if (string2 == null) {
                LightFilePointer.$$$reportNull$$$0(3);
            }
            return string2;
        }
        int index2 = this.myUrl.lastIndexOf(47);
        String string3 = index2 >= 0 ? this.myUrl.substring(index2 + 1) : this.myUrl;
        if (string3 == null) {
            LightFilePointer.$$$reportNull$$$0(4);
        }
        return string3;
    }

    @Override
    @NotNull
    public String getPresentableUrl() {
        VirtualFile file2 = this.getFile();
        if (file2 != null) {
            String string2 = file2.getPresentableUrl();
            if (string2 == null) {
                LightFilePointer.$$$reportNull$$$0(5);
            }
            return string2;
        }
        return LightFilePointer.toPresentableUrl(this.myUrl);
    }

    @NotNull
    private static String toPresentableUrl(@NotNull String url) {
        if (url == null) {
            LightFilePointer.$$$reportNull$$$0(6);
        }
        String path = VirtualFileManager.extractPath(url);
        String protocol = VirtualFileManager.extractProtocol(url);
        VirtualFileSystem fileSystem = VirtualFileManager.getInstance().getFileSystem(protocol);
        String string2 = ObjectUtils.notNull(fileSystem, StandardFileSystems.local()).extractPresentableUrl(path);
        if (string2 == null) {
            LightFilePointer.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    public boolean isValid() {
        return this.getFile() != null;
    }

    private void refreshFile() {
        VirtualFile file2 = this.myFile;
        if (file2 != null && file2.isValid()) {
            return;
        }
        VirtualFileManager vfManager = VirtualFileManager.getInstance();
        VirtualFile virtualFile2 = vfManager.findFileByUrl(this.myUrl);
        if (virtualFile2 == null && !this.myRefreshed) {
            this.myRefreshed = true;
            Application application = ApplicationManager.getApplication();
            if (application.isDispatchThread() || !application.isReadAccessAllowed()) {
                virtualFile2 = vfManager.refreshAndFindFileByUrl(this.myUrl);
            } else {
                application.executeOnPooledThread(() -> vfManager.refreshAndFindFileByUrl(this.myUrl));
            }
        }
        this.myFile = virtualFile2 != null && virtualFile2.isValid() ? virtualFile2 : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LightFilePointer)) {
            return false;
        }
        return this.myUrl.equals(((LightFilePointer)o).myUrl);
    }

    public int hashCode() {
        return this.myUrl.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/openapi/vfs/impl/LightFilePointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/openapi/vfs/impl/LightFilePointer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableUrl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toPresentableUrl";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

