/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ksp.com.intellij.openapi.diagnostic.Logger;
import ksp.com.intellij.openapi.util.DefaultJDOMExternalizer;
import ksp.com.intellij.openapi.util.JDOMExternalizable;
import ksp.com.intellij.util.ReflectionUtil;
import ksp.org.jdom.Element;
import ksp.org.jdom.IllegalDataException;
import ksp.org.jetbrains.annotations.NotNull;

@Deprecated
public class JDOMExternalizableStringList
extends ArrayList<String>
implements JDOMExternalizable {
    private static final Logger LOG = Logger.getInstance(JDOMExternalizableStringList.class);
    private static final String ATTR_LIST = "list";
    private static final String ATTR_LISTSIZE = "size";
    private static final String ATTR_ITEM = "item";
    private static final String ATTR_INDEX = "index";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_VALUE = "itemvalue";

    public JDOMExternalizableStringList(int initialCapacity) {
        super(initialCapacity);
    }

    public JDOMExternalizableStringList() {
    }

    public JDOMExternalizableStringList(@NotNull Collection<String> c) {
        if (c == null) {
            JDOMExternalizableStringList.$$$reportNull$$$0(0);
        }
        super(c);
    }

    @Override
    public void readExternal(Element element2) {
        JDOMExternalizableStringList.readList(this, element2);
    }

    public static void readList(@NotNull List<? super String> strings2, Element element2) {
        if (strings2 == null) {
            JDOMExternalizableStringList.$$$reportNull$$$0(1);
        }
        strings2.clear();
        Class<?> callerClass = null;
        for (Element listElement : element2.getChildren(ATTR_LIST)) {
            if (callerClass == null) {
                callerClass = ReflectionUtil.findCallerClass(2);
                assert (callerClass != null);
            }
            ClassLoader classLoader = callerClass.getClassLoader();
            for (Element listItemElement : listElement.getChildren(ATTR_ITEM)) {
                Class<String> itemClass;
                if (!ATTR_ITEM.equals(listItemElement.getName())) {
                    throw new IllegalDataException("Unable to read list item. Unknown element found: " + listItemElement.getName());
                }
                String itemClassString = listItemElement.getAttributeValue(ATTR_CLASS);
                try {
                    itemClass = itemClassString == null ? String.class : Class.forName(itemClassString, true, classLoader);
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalDataException("Unable to read list item: unable to load class: " + itemClassString + " \n" + ex.getMessage());
                }
                String listItem = listItemElement.getAttributeValue(ATTR_VALUE);
                LOG.assertTrue(String.class.equals(itemClass));
                strings2.add(listItem);
            }
        }
    }

    @Override
    public void writeExternal(Element element2) {
        JDOMExternalizableStringList.writeList(this, element2);
    }

    private static void writeList(@NotNull List<String> strings2, @NotNull Element element2) {
        if (strings2 == null) {
            JDOMExternalizableStringList.$$$reportNull$$$0(2);
        }
        if (element2 == null) {
            JDOMExternalizableStringList.$$$reportNull$$$0(3);
        }
        int listSize = strings2.size();
        Element listElement = new Element(ATTR_LIST);
        listElement.setAttribute(ATTR_LISTSIZE, Integer.toString(listSize));
        element2.addContent(listElement);
        for (int i = 0; i < listSize; ++i) {
            String listItem = strings2.get(i);
            if (listItem == null) continue;
            Element itemElement = new Element(ATTR_ITEM);
            itemElement.setAttribute(ATTR_INDEX, Integer.toString(i));
            itemElement.setAttribute(ATTR_CLASS, listItem.getClass().getName());
            itemElement.setAttribute(ATTR_VALUE, DefaultJDOMExternalizer.filterXMLCharacters(listItem));
            listElement.addContent(itemElement);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/openapi/util/JDOMExternalizableStringList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "readList";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writeList";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

