/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.openapi.command.undo;

import ksp.com.intellij.openapi.command.CommandProcessor;
import ksp.com.intellij.openapi.command.undo.UndoConstants;
import ksp.com.intellij.openapi.editor.Document;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.vfs.VirtualFile;
import ksp.com.intellij.psi.PsiDocumentManager;
import ksp.com.intellij.psi.PsiFile;
import ksp.org.jetbrains.annotations.NotNull;

public final class UndoUtil {
    private UndoUtil() {
    }

    public static void markPsiFileForUndo(@NotNull PsiFile file2) {
        Project project;
        Document document2;
        if (file2 == null) {
            UndoUtil.$$$reportNull$$$0(0);
        }
        if ((document2 = PsiDocumentManager.getInstance(project = file2.getProject()).getDocument(file2)) == null) {
            return;
        }
        CommandProcessor.getInstance().addAffectedDocuments(project, document2);
    }

    public static void disableUndoFor(@NotNull Document document2) {
        if (document2 == null) {
            UndoUtil.$$$reportNull$$$0(1);
        }
        document2.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
    }

    public static void disableUndoIn(@NotNull Document document2, @NotNull Runnable runnable) {
        if (document2 == null) {
            UndoUtil.$$$reportNull$$$0(2);
        }
        if (runnable == null) {
            UndoUtil.$$$reportNull$$$0(3);
        }
        document2.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
        try {
            runnable.run();
        }
        finally {
            document2.putUserData(UndoConstants.DONT_RECORD_UNDO, null);
        }
    }

    public static void disableUndoFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            UndoUtil.$$$reportNull$$$0(4);
        }
        file2.putUserData(UndoConstants.DONT_RECORD_UNDO, Boolean.TRUE);
    }

    public static void enableUndoFor(@NotNull Document document2) {
        if (document2 == null) {
            UndoUtil.$$$reportNull$$$0(5);
        }
        document2.putUserData(UndoConstants.DONT_RECORD_UNDO, null);
    }

    public static boolean isUndoDisabledFor(@NotNull Document document2) {
        if (document2 == null) {
            UndoUtil.$$$reportNull$$$0(6);
        }
        return Boolean.TRUE.equals(document2.getUserData(UndoConstants.DONT_RECORD_UNDO));
    }

    public static boolean isUndoDisabledFor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            UndoUtil.$$$reportNull$$$0(7);
        }
        return Boolean.TRUE.equals(file2.getUserData(UndoConstants.DONT_RECORD_UNDO));
    }

    public static void forceUndoIn(@NotNull VirtualFile file2, @NotNull Runnable runnable) {
        if (file2 == null) {
            UndoUtil.$$$reportNull$$$0(8);
        }
        if (runnable == null) {
            UndoUtil.$$$reportNull$$$0(9);
        }
        file2.putUserData(UndoConstants.FORCE_RECORD_UNDO, Boolean.TRUE);
        try {
            runnable.run();
        }
        finally {
            file2.putUserData(UndoConstants.FORCE_RECORD_UNDO, null);
        }
    }

    public static void setForceUndoFlag(@NotNull VirtualFile file2, boolean flag) {
        if (file2 == null) {
            UndoUtil.$$$reportNull$$$0(10);
        }
        file2.putUserData(UndoConstants.FORCE_RECORD_UNDO, flag ? Boolean.TRUE : null);
    }

    public static boolean isForceUndoFlagSet(@NotNull VirtualFile file2) {
        if (file2 == null) {
            UndoUtil.$$$reportNull$$$0(11);
        }
        return file2.getUserData(UndoConstants.FORCE_RECORD_UNDO) == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "ksp/com/intellij/openapi/command/undo/UndoUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "markPsiFileForUndo";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "disableUndoFor";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "disableUndoIn";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "enableUndoFor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isUndoDisabledFor";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "forceUndoIn";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setForceUndoFlag";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isForceUndoFlagSet";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

