/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.processor.internal.BaseProcessingStep;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.HiltProcessingEnvConfigs;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingStep;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XRoundEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.javac.JavacBasicAnnotationProcessor;
import java.util.Set;
import javax.lang.model.SourceVersion;

public abstract class JavacBaseProcessingStepProcessor
extends JavacBasicAnnotationProcessor {
    private BaseProcessingStep processingStep;

    public JavacBaseProcessingStepProcessor() {
        super(HiltProcessingEnvConfigs.CONFIGS);
    }

    public void initialize(XProcessingEnv env) {
        HiltCompilerOptions.checkWrongAndDeprecatedOptions(env);
        this.processingStep = this.processingStep();
    }

    public final SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    public final ImmutableSet<String> getSupportedOptions() {
        return ImmutableSet.builder().addAll(HiltCompilerOptions.getProcessorOptions()).addAll(this.additionalProcessingOptions()).build();
    }

    public final ImmutableList<XProcessingStep> processingSteps() {
        return ImmutableList.of((Object)this.processingStep);
    }

    public void preRound(XProcessingEnv env, XRoundEnv round) {
        this.processingStep.preRoundProcess(env, round);
    }

    protected abstract BaseProcessingStep processingStep();

    public void postRound(XProcessingEnv env, XRoundEnv round) {
        this.processingStep.postRoundProcess(env, round);
    }

    protected Set<String> additionalProcessingOptions() {
        return ImmutableSet.of();
    }
}

