/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.aggregateddeps.AggregatedDepsMetadata;
import dagger.hilt.processor.internal.aggregateddeps.AutoValue_ComponentDependencies;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateMetadata;
import dagger.hilt.processor.internal.earlyentrypoint.AggregatedEarlyEntryPointMetadata;
import dagger.hilt.processor.internal.uninstallmodules.AggregatedUninstallModulesMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;

@AutoValue
public abstract class ComponentDependencies {
    private static Builder builder() {
        return new AutoValue_ComponentDependencies.Builder();
    }

    public abstract ImmutableSetMultimap<ClassName, XTypeElement> modules();

    public abstract ImmutableSetMultimap<ClassName, XTypeElement> entryPoints();

    public abstract ImmutableSetMultimap<ClassName, XTypeElement> componentEntryPoints();

    public static ComponentDependencies from(ImmutableSet<ComponentDescriptor> descriptors, ImmutableSet<AggregatedDepsMetadata> aggregatedDepsMetadata, ImmutableSet<AggregatedUninstallModulesMetadata> aggregatedUninstallModulesMetadata, ImmutableSet<AggregatedEarlyEntryPointMetadata> aggregatedEarlyEntryPointMetadata, XProcessingEnv env) {
        ImmutableSet uninstalledModules = ImmutableSet.builder().addAll((Iterable)aggregatedUninstallModulesMetadata.stream().flatMap(metadata -> metadata.uninstallModuleElements().stream()).map(module -> PkgPrivateMetadata.publicModule(module)).collect(DaggerStreams.toImmutableSet())).addAll((Iterable)aggregatedDepsMetadata.stream().flatMap(metadata -> metadata.replacedDependencies().stream()).collect(DaggerStreams.toImmutableSet())).build();
        Builder componentDependencies = ComponentDependencies.builder();
        ImmutableSet componentNames = (ImmutableSet)descriptors.stream().map(ComponentDescriptor::component).collect(DaggerStreams.toImmutableSet());
        for (AggregatedDepsMetadata metadata2 : aggregatedDepsMetadata) {
            for (XTypeElement componentElement : metadata2.componentElements()) {
                ClassName componentName = componentElement.getClassName();
                Preconditions.checkState((boolean)componentNames.contains((Object)componentName), (String)"%s is not a valid Component.", (Object)componentName);
                switch (metadata2.dependencyType()) {
                    case MODULE: {
                        if (uninstalledModules.contains((Object)metadata2.dependency())) break;
                        componentDependencies.modulesBuilder().put((Object)componentName, (Object)metadata2.dependency());
                        break;
                    }
                    case ENTRY_POINT: {
                        componentDependencies.entryPointsBuilder().put((Object)componentName, (Object)metadata2.dependency());
                        break;
                    }
                    case COMPONENT_ENTRY_POINT: {
                        componentDependencies.componentEntryPointsBuilder().put((Object)componentName, (Object)metadata2.dependency());
                    }
                }
            }
        }
        componentDependencies.entryPointsBuilder().putAll((Object)ClassNames.SINGLETON_COMPONENT, (Iterable)aggregatedEarlyEntryPointMetadata.stream().map(AggregatedEarlyEntryPointMetadata::earlyEntryPoint).map(PkgPrivateMetadata::publicEarlyEntryPoint).collect(DaggerStreams.toImmutableSet()));
        return componentDependencies.build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract ImmutableSetMultimap.Builder<ClassName, XTypeElement> modulesBuilder();

        abstract ImmutableSetMultimap.Builder<ClassName, XTypeElement> entryPointsBuilder();

        abstract ImmutableSetMultimap.Builder<ClassName, XTypeElement> componentEntryPointsBuilder();

        abstract ComponentDependencies build();
    }
}

