/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.bindvalue;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.processor.internal.bindvalue.AutoValue_BindValueMetadata;
import dagger.hilt.android.processor.internal.bindvalue.AutoValue_BindValueMetadata_BindValueElement;
import dagger.hilt.android.processor.internal.bindvalue.BindValueProcessingStep;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import java.util.Optional;

@AutoValue
abstract class BindValueMetadata {
    static final ImmutableSet<ClassName> BIND_VALUE_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.ANDROID_BIND_VALUE);
    static final ImmutableSet<ClassName> BIND_VALUE_INTO_SET_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.ANDROID_BIND_VALUE_INTO_SET);
    static final ImmutableSet<ClassName> BIND_ELEMENTS_INTO_SET_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.ANDROID_BIND_ELEMENTS_INTO_SET);
    static final ImmutableSet<ClassName> BIND_VALUE_INTO_MAP_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.ANDROID_BIND_VALUE_INTO_MAP);

    BindValueMetadata() {
    }

    abstract XTypeElement testElement();

    abstract ImmutableSet<BindValueElement> bindValueElements();

    static BindValueMetadata create(XTypeElement testElement, Collection<XElement> bindValueElements) {
        ImmutableSet.Builder elements = ImmutableSet.builder();
        for (XElement element : bindValueElements) {
            elements.add((Object)BindValueElement.create(element));
        }
        return new AutoValue_BindValueMetadata(testElement, (ImmutableSet<BindValueElement>)elements.build());
    }

    @AutoValue
    static abstract class BindValueElement {
        BindValueElement() {
        }

        abstract XFieldElement fieldElement();

        abstract ClassName annotationName();

        abstract Optional<XAnnotation> qualifier();

        abstract Optional<XAnnotation> mapKey();

        abstract Optional<XMethodElement> getterElement();

        static BindValueElement create(XElement element) {
            Optional<XAnnotation> optionalMapKeys;
            ImmutableList<ClassName> bindValues = BindValueProcessingStep.getBindValueAnnotations(element);
            ProcessorErrors.checkState(bindValues.size() == 1, element, "Fields can be annotated with only one of @BindValue, @BindValueIntoMap, @BindElementsIntoSet, @BindValueIntoSet. Found: %s", bindValues.stream().map(m -> "@" + m.simpleName()).collect(DaggerStreams.toImmutableList()));
            ClassName annotationClassName = (ClassName)Iterables.getOnlyElement(bindValues);
            ProcessorErrors.checkState(XElementKt.isField((XElement)element), element, "@%s can only be used with fields. Found: %s", annotationClassName.simpleName(), XElements.toStableString((XElement)element));
            XFieldElement field = XElements.asField((XElement)element);
            Optional<XMethodElement> propertyGetter = Optional.ofNullable(field.getGetter());
            if (propertyGetter.isPresent()) {
                ProcessorErrors.checkState(!propertyGetter.get().isPrivate(), (XElement)field, "@%s field getter cannot be private. Found: %s", annotationClassName.simpleName(), XElements.toStableString((XElement)field));
            } else {
                ProcessorErrors.checkState(!XElements.isPrivate((XElement)field), (XElement)field, "@%s fields cannot be private. Found: %s", annotationClassName.simpleName(), XElements.toStableString((XElement)field));
            }
            ProcessorErrors.checkState(!field.hasAnnotation(ClassNames.INJECT), (XElement)field, "@%s fields cannot be used with @Inject annotation. Found %s", annotationClassName.simpleName(), XElements.toStableString((XElement)field));
            ImmutableList<XAnnotation> qualifiers = Processors.getQualifierAnnotations((XElement)field);
            ProcessorErrors.checkState(qualifiers.size() <= 1, (XElement)field, "@%s fields cannot have more than one qualifier. Found %s", annotationClassName.simpleName(), qualifiers.stream().map(XAnnotations::toStableString).collect(DaggerStreams.toImmutableList()));
            ImmutableList<XAnnotation> mapKeys = Processors.getMapKeyAnnotations((XElement)field);
            if (BIND_VALUE_INTO_MAP_ANNOTATIONS.contains((Object)annotationClassName)) {
                ProcessorErrors.checkState(mapKeys.size() == 1, (XElement)field, "@BindValueIntoMap fields must have exactly one @MapKey. Found %s", mapKeys.stream().map(XAnnotations::toStableString).collect(DaggerStreams.toImmutableList()));
                optionalMapKeys = Optional.of((XAnnotation)mapKeys.get(0));
            } else {
                ProcessorErrors.checkState(mapKeys.isEmpty(), (XElement)field, "@MapKey can only be used on @BindValueIntoMap fields, not @%s fields", annotationClassName.simpleName());
                optionalMapKeys = Optional.empty();
            }
            ImmutableList<XAnnotation> scopes = Processors.getScopeAnnotations((XElement)field);
            ProcessorErrors.checkState(scopes.isEmpty(), (XElement)field, "@%s fields cannot be scoped. Found %s", annotationClassName.simpleName(), scopes.stream().map(XAnnotations::toStableString).collect(DaggerStreams.toImmutableList()));
            return new AutoValue_BindValueMetadata_BindValueElement(field, annotationClassName, qualifiers.isEmpty() ? Optional.empty() : Optional.of((XAnnotation)qualifiers.get(0)), optionalMapKeys, propertyGetter);
        }
    }
}

