/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.kotlin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.kotlin.KotlinMetadata;
import dagger.hilt.processor.internal.kotlin.KotlinMetadataFactory;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.Optional;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import kotlin.Metadata;
import kotlinx.metadata.Flag;

public final class KotlinMetadataUtil {
    private final KotlinMetadataFactory metadataFactory;

    @Inject
    KotlinMetadataUtil(KotlinMetadataFactory metadataFactory) {
        this.metadataFactory = metadataFactory;
    }

    public boolean hasMetadata(Element element) {
        return MoreElements.isAnnotationPresent((Element)KotlinMetadataUtil.closestEnclosingTypeElement(element), Metadata.class);
    }

    public ImmutableList<? extends AnnotationMirror> getSyntheticPropertyAnnotations(VariableElement fieldElement, ClassName annotationType) {
        return this.metadataFactory.create(fieldElement).getSyntheticAnnotationMethod(fieldElement).map(methodElement -> KotlinMetadataUtil.getAnnotationsAnnotatedWith(methodElement, annotationType)).orElse(ImmutableList.of());
    }

    private static ImmutableList<AnnotationMirror> getAnnotationsAnnotatedWith(Element element, ClassName subAnnotation) {
        return (ImmutableList)element.getAnnotationMirrors().stream().filter(annotation -> MoreElements.isAnnotationPresent(annotation.getAnnotationType().asElement(), subAnnotation.canonicalName())).collect(DaggerStreams.toImmutableList());
    }

    public boolean isMissingSyntheticPropertyForAnnotations(VariableElement fieldElement) {
        return this.metadataFactory.create(fieldElement).isMissingSyntheticAnnotationMethod(fieldElement);
    }

    public boolean isObjectClass(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).classMetadata().flags(Flag.Class.IS_OBJECT);
    }

    public boolean isDataClass(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).classMetadata().flags(Flag.Class.IS_DATA);
    }

    public boolean isCompanionObjectClass(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).classMetadata().flags(Flag.Class.IS_COMPANION_OBJECT);
    }

    public boolean isObjectOrCompanionObjectClass(TypeElement typeElement) {
        return this.isObjectClass(typeElement) || this.isCompanionObjectClass(typeElement);
    }

    public boolean hasEnclosedCompanionObject(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).classMetadata().companionObjectName().isPresent();
    }

    public TypeElement getEnclosedCompanionObject(TypeElement typeElement) {
        return this.metadataFactory.create(typeElement).classMetadata().companionObjectName().map(companionObjectName -> (TypeElement)ElementFilter.typesIn(typeElement.getEnclosedElements()).stream().filter(innerType -> innerType.getSimpleName().contentEquals((CharSequence)companionObjectName)).collect(DaggerCollectors.onlyElement())).get();
    }

    public boolean isVisibilityPrivate(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).classMetadata().flags(Flag.IS_PRIVATE);
    }

    public boolean isVisibilityInternal(TypeElement type) {
        return this.hasMetadata(type) && this.metadataFactory.create(type).classMetadata().flags(Flag.IS_INTERNAL);
    }

    public boolean isVisibilityInternal(ExecutableElement method) {
        return this.hasMetadata(method) && this.metadataFactory.create(method).getFunctionMetadata(method).flags(Flag.IS_INTERNAL);
    }

    public Optional<ExecutableElement> getPropertyGetter(VariableElement fieldElement) {
        return this.metadataFactory.create(fieldElement).getPropertyGetter(fieldElement);
    }

    public boolean containsConstructorWithDefaultParam(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).containsConstructorWithDefaultParam();
    }

    public ImmutableMap<String, String> getAllMethodNamesBySignature(TypeElement element) {
        Preconditions.checkState((boolean)this.hasMetadata(element), (Object)"Can not call getAllMethodNamesBySignature for non-Kotlin class");
        return (ImmutableMap)this.metadataFactory.create(element).classMetadata().functionsBySignature().values().stream().collect(DaggerStreams.toImmutableMap(KotlinMetadata.FunctionMetadata::signature, KotlinMetadata.BaseMetadata::name));
    }

    static TypeElement closestEnclosingTypeElement(Element element) {
        for (Element current = element; current != null; current = current.getEnclosingElement()) {
            if (!MoreElements.isType(current)) continue;
            return MoreElements.asType(current);
        }
        throw new IllegalStateException("There is no enclosing TypeElement for: " + element);
    }
}

