/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.definecomponent;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.shaded.auto.common.AnnotationMirrors;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.android.shaded.auto.common.MoreTypes;
import dagger.hilt.processor.internal.AnnotationValues;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.definecomponent.AutoValue_DefineComponentMetadatas_DefineComponentMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

final class DefineComponentMetadatas {
    private final Map<Element, DefineComponentMetadata> metadatas = new HashMap<Element, DefineComponentMetadata>();

    static DefineComponentMetadatas create() {
        return new DefineComponentMetadatas();
    }

    private DefineComponentMetadatas() {
    }

    DefineComponentMetadata get(Element element) {
        return this.get(element, new LinkedHashSet<Element>());
    }

    private DefineComponentMetadata get(Element element, LinkedHashSet<Element> childPath) {
        if (!this.metadatas.containsKey(element)) {
            this.metadatas.put(element, this.getUncached(element, childPath));
        }
        return this.metadatas.get(element);
    }

    private DefineComponentMetadata getUncached(Element element, LinkedHashSet<Element> childPath) {
        ProcessorErrors.checkState(childPath.add(element), element, "@DefineComponent cycle: %s -> %s", childPath.stream().map(Object::toString).collect(Collectors.joining(" -> ")), element);
        ProcessorErrors.checkState(Processors.hasAnnotation(element, ClassNames.DEFINE_COMPONENT), element, "%s, expected to be annotated with @DefineComponent. Found: %s", element, element.getAnnotationMirrors());
        ProcessorErrors.checkState(element.getKind().equals((Object)ElementKind.INTERFACE), element, "@DefineComponent is only allowed on interfaces. Found: %s", element);
        TypeElement component = MoreElements.asType(element);
        ProcessorErrors.checkState(component.getInterfaces().isEmpty(), component, "@DefineComponent %s, cannot extend a super class or interface. Found: %s", component, component.getInterfaces());
        ProcessorErrors.checkState(component.getTypeParameters().isEmpty(), component, "@DefineComponent %s, cannot have type parameters.", component.asType());
        List nonStaticMethods = ElementFilter.methodsIn(component.getEnclosedElements()).stream().filter(method -> !method.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
        ProcessorErrors.checkState(nonStaticMethods.isEmpty(), component, "@DefineComponent %s, cannot have non-static methods. Found: %s", component, nonStaticMethods);
        ImmutableList scopes = (ImmutableList)Processors.getScopeAnnotations(component).stream().map(AnnotationMirror::getAnnotationType).map(MoreTypes::asTypeElement).collect(DaggerStreams.toImmutableList());
        ImmutableList<AnnotationMirror> aliasScopes = Processors.getAnnotationsAnnotatedWith(component, ClassNames.ALIAS_OF);
        ProcessorErrors.checkState(aliasScopes.isEmpty(), component, "@DefineComponent %s, references invalid scope(s) annotated with @AliasOf. @DefineComponent scopes cannot be aliases of other scopes: %s", component, aliasScopes);
        AnnotationMirror mirror = Processors.getAnnotationMirror((Element)component, ClassNames.DEFINE_COMPONENT);
        AnnotationValue parentValue = AnnotationMirrors.getAnnotationElementAndValue(mirror, "parent").getValue();
        ProcessorErrors.checkState(!"<error>".contentEquals(parentValue.getValue().toString()), component, "@DefineComponent %s, references an invalid parent type: %s", component, mirror);
        TypeElement parent = MoreTypes.asTypeElement(AnnotationValues.getTypeMirror(parentValue));
        ProcessorErrors.checkState(ClassName.get((TypeElement)parent).equals((Object)ClassNames.DEFINE_COMPONENT_NO_PARENT) || Processors.hasAnnotation((Element)parent, ClassNames.DEFINE_COMPONENT), component, "@DefineComponent %s, references a type not annotated with @DefineComponent: %s", component, parent);
        Optional<DefineComponentMetadata> parentComponent = ClassName.get((TypeElement)parent).equals((Object)ClassNames.DEFINE_COMPONENT_NO_PARENT) ? Optional.empty() : Optional.of(this.get(parent, childPath));
        ClassName componentClassName = ClassName.get((TypeElement)component);
        ProcessorErrors.checkState(parentComponent.isPresent() || componentClassName.equals((Object)ClassNames.SINGLETON_COMPONENT), component, "@DefineComponent %s is missing a parent declaration.\nPlease declare the parent, for example: @DefineComponent(parent = SingletonComponent.class)", component);
        ProcessorErrors.checkState(componentClassName.equals((Object)ClassNames.SINGLETON_COMPONENT) || !componentClassName.simpleName().equals(ClassNames.SINGLETON_COMPONENT.simpleName()), component, "Cannot have a component with the same simple name as the reserved %s: %s", ClassNames.SINGLETON_COMPONENT.simpleName(), componentClassName);
        return new AutoValue_DefineComponentMetadatas_DefineComponentMetadata(component, (ImmutableList<TypeElement>)scopes, parentComponent);
    }

    @AutoValue
    static abstract class DefineComponentMetadata {
        DefineComponentMetadata() {
        }

        abstract TypeElement component();

        abstract ImmutableList<TypeElement> scopes();

        abstract Optional<DefineComponentMetadata> parentMetadata();

        boolean isRoot() {
            return !this.parentMetadata().isPresent();
        }
    }
}

