/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.android.shaded.auto.common.MoreTypes;
import dagger.hilt.android.shaded.auto.common.Visibility;
import dagger.hilt.processor.internal.Processors;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public final class ViewGenerator {
    private final ProcessingEnvironment env;
    private final AndroidEntryPointMetadata metadata;
    private final ClassName generatedClassName;

    public ViewGenerator(ProcessingEnvironment env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
        this.generatedClassName = metadata.generatedClassName();
    }

    public void generate() throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.generatedClassName.simpleName()).addOriginatingElement((Element)this.metadata.element()).superclass(this.metadata.baseClassName()).addModifiers(this.metadata.generatedClassModifiers());
        Generators.addGeneratedBaseClassJavadoc(builder, AndroidClassNames.ANDROID_ENTRY_POINT);
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        Generators.copyLintAnnotations(this.metadata.element(), builder);
        Generators.copySuppressAnnotations(this.metadata.element(), builder);
        this.metadata.baseElement().getTypeParameters().stream().map(TypeVariableName::get).forEachOrdered(arg_0 -> ((TypeSpec.Builder)builder).addTypeVariable(arg_0));
        Generators.addComponentOverride(this.metadata, builder);
        Generators.addInjectionMethods(this.metadata, builder);
        ElementFilter.constructorsIn(this.metadata.baseElement().getEnclosedElements()).stream().filter(this::isConstructorVisibleToGeneratedClass).forEach(constructor -> builder.addMethod(this.constructorMethod((ExecutableElement)constructor)));
        JavaFile.builder((String)this.generatedClassName.packageName(), (TypeSpec)builder.build()).build().writeTo(this.env.getFiler());
    }

    private boolean isConstructorVisibleToGeneratedClass(ExecutableElement constructorElement) {
        if (Visibility.ofElement(constructorElement) == Visibility.DEFAULT && !this.isInOurPackage(constructorElement)) {
            return false;
        }
        return Visibility.ofElement(constructorElement) != Visibility.PRIVATE;
    }

    private MethodSpec constructorMethod(ExecutableElement constructorElement) {
        MethodSpec.Builder constructor = Generators.copyConstructor(constructorElement).toBuilder();
        if (this.isRestrictedApiConstructor(constructorElement)) {
            constructor.addAnnotation(AnnotationSpec.builder((ClassName)AndroidClassNames.TARGET_API).addMember("value", "21", new Object[0]).build());
        }
        constructor.addStatement("inject()", new Object[0]);
        return constructor.build();
    }

    private boolean isRestrictedApiConstructor(ExecutableElement constructor) {
        if (constructor.getParameters().size() != 4) {
            return false;
        }
        List<? extends VariableElement> constructorParams = constructor.getParameters();
        block6: for (int i = 0; i < constructorParams.size(); ++i) {
            TypeMirror type = constructorParams.get(i).asType();
            switch (i) {
                case 0: {
                    if (ViewGenerator.isFirstRestrictedParameter(type)) continue block6;
                    return false;
                }
                case 1: {
                    if (ViewGenerator.isSecondRestrictedParameter(type)) continue block6;
                    return false;
                }
                case 2: {
                    if (ViewGenerator.isThirdRestrictedParameter(type)) continue block6;
                    return false;
                }
                case 3: {
                    if (ViewGenerator.isFourthRestrictedParameter(type)) continue block6;
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean isFourthRestrictedParameter(TypeMirror type) {
        return type.getKind().isPrimitive() && Processors.getPrimitiveType(type).getKind() == TypeKind.INT;
    }

    private static boolean isThirdRestrictedParameter(TypeMirror type) {
        return type.getKind().isPrimitive() && Processors.getPrimitiveType(type).getKind() == TypeKind.INT;
    }

    private static boolean isSecondRestrictedParameter(TypeMirror type) {
        return type.getKind() == TypeKind.DECLARED && Processors.isAssignableFrom(MoreTypes.asTypeElement(type), AndroidClassNames.ATTRIBUTE_SET);
    }

    private static boolean isFirstRestrictedParameter(TypeMirror type) {
        return type.getKind() == TypeKind.DECLARED && Processors.isAssignableFrom(MoreTypes.asTypeElement(type), AndroidClassNames.CONTEXT);
    }

    private boolean isInOurPackage(ExecutableElement constructorElement) {
        return MoreElements.getPackage(constructorElement).equals(MoreElements.getPackage(this.metadata.element()));
    }
}

