/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.auto.value.AutoValue;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.root.AutoValue_TestRootMetadata;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@AutoValue
abstract class TestRootMetadata {
    TestRootMetadata() {
    }

    abstract TypeElement testElement();

    abstract TypeElement baseElement();

    ClassName testName() {
        return ClassName.get((TypeElement)this.testElement());
    }

    ClassName baseAppName() {
        return ClassName.get((TypeElement)this.baseElement());
    }

    ClassName appName() {
        return Processors.append(Processors.getEnclosedClassName(this.testName()), "_Application");
    }

    ClassName testInjectorName() {
        return Processors.append(Processors.getEnclosedClassName(this.testName()), "_GeneratedInjector");
    }

    static TestRootMetadata of(ProcessingEnvironment env, Element element) {
        TypeElement testElement = MoreElements.asType(element);
        TypeElement baseElement = env.getElementUtils().getTypeElement(ClassNames.MULTI_DEX_APPLICATION.toString());
        ProcessorErrors.checkState(!Processors.hasAnnotation(element, ClassNames.ANDROID_ENTRY_POINT), element, (Object)"Tests cannot be annotated with @AndroidEntryPoint. Please use @HiltAndroidTest");
        ProcessorErrors.checkState(Processors.hasAnnotation(element, ClassNames.HILT_ANDROID_TEST), element, (Object)"Tests must be annotated with @HiltAndroidTest");
        return new AutoValue_TestRootMetadata(testElement, baseElement);
    }
}

