/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.ApplicationGenerator;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.ComponentNames;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aggregateddeps.AggregatedDepsMetadata;
import dagger.hilt.processor.internal.aggregateddeps.ComponentDependencies;
import dagger.hilt.processor.internal.aliasof.AliasOfPropagatedDataMetadata;
import dagger.hilt.processor.internal.aliasof.AliasOfs;
import dagger.hilt.processor.internal.definecomponent.DefineComponentClassesMetadata;
import dagger.hilt.processor.internal.definecomponent.DefineComponents;
import dagger.hilt.processor.internal.earlyentrypoint.AggregatedEarlyEntryPointMetadata;
import dagger.hilt.processor.internal.root.AggregatedRootMetadata;
import dagger.hilt.processor.internal.root.ComponentTree;
import dagger.hilt.processor.internal.root.ComponentTreeDepsMetadata;
import dagger.hilt.processor.internal.root.EarlySingletonComponentCreatorGenerator;
import dagger.hilt.processor.internal.root.Root;
import dagger.hilt.processor.internal.root.RootGenerator;
import dagger.hilt.processor.internal.root.RootMetadata;
import dagger.hilt.processor.internal.root.TestComponentDataGenerator;
import dagger.hilt.processor.internal.uninstallmodules.AggregatedUninstallModulesMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

@AutoService(value={Processor.class})
public final class ComponentTreeDepsProcessor
extends BaseProcessor {
    private final Set<ClassName> componentTreeDepNames = new HashSet<ClassName>();
    private final Set<ClassName> processed = new HashSet<ClassName>();
    private final DefineComponents defineComponents = DefineComponents.create();

    public ImmutableSet<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)ClassNames.COMPONENT_TREE_DEPS.toString());
    }

    @Override
    public void processEach(TypeElement annotation, Element element) {
        this.componentTreeDepNames.add(ClassName.get((TypeElement)MoreElements.asType(element)));
    }

    @Override
    public void postRoundProcess(RoundEnvironment roundEnv) throws Exception {
        ImmutableSet componentTreeDepsToProcess = (ImmutableSet)this.componentTreeDepNames.stream().filter(className -> !this.processed.contains(className)).map(className -> this.getElementUtils().getTypeElement(className.canonicalName())).map(element -> ComponentTreeDepsMetadata.from(element, this.getElementUtils())).collect(DaggerStreams.toImmutableSet());
        for (ComponentTreeDepsMetadata metadata : componentTreeDepsToProcess) {
            this.processComponentTreeDeps(metadata);
        }
    }

    private void processComponentTreeDeps(ComponentTreeDepsMetadata metadata) throws IOException {
        TypeElement metadataElement = this.getElementUtils().getTypeElement(metadata.name().canonicalName());
        try {
            ClassName renamedRoot = Processors.removeNameSuffix(metadataElement, "_ComponentTreeDeps");
            ComponentNames componentNames = ComponentNames.withRenaming(rootName -> renamedRoot);
            boolean isDefaultRoot = ClassNames.DEFAULT_ROOT.equals((Object)renamedRoot);
            ImmutableSet roots = (ImmutableSet)AggregatedRootMetadata.from(metadata.aggregatedRootDeps(), this.processingEnv).stream().map(AggregatedRootMetadata::rootElement).map(rootElement -> Root.create(rootElement, this.getProcessingEnv())).collect(DaggerStreams.toImmutableSet());
            Root root = isDefaultRoot ? Root.createDefaultRoot(this.getProcessingEnv()) : (Root)Iterables.getOnlyElement((Iterable)roots);
            ImmutableSet<ComponentDescriptor> componentDescriptors = this.defineComponents.getComponentDescriptors(DefineComponentClassesMetadata.from(metadata.defineComponentDeps(), this.getElementUtils()));
            ComponentTree tree = ComponentTree.from(componentDescriptors);
            ComponentDependencies deps = ComponentDependencies.from(componentDescriptors, AggregatedDepsMetadata.from(metadata.aggregatedDeps(), this.getElementUtils()), AggregatedUninstallModulesMetadata.from(metadata.aggregatedUninstallModulesDeps(), this.getElementUtils()), AggregatedEarlyEntryPointMetadata.from(metadata.aggregatedEarlyEntryPointDeps(), this.getElementUtils()), this.getElementUtils());
            AliasOfs aliasOfs = AliasOfs.create(AliasOfPropagatedDataMetadata.from(metadata.aliasOfDeps(), this.getElementUtils()), componentDescriptors);
            RootMetadata rootMetadata = RootMetadata.create(root, tree, deps, aliasOfs, this.getProcessingEnv());
            this.generateComponents(metadata, rootMetadata, componentNames);
            if (isDefaultRoot && !metadata.aggregatedEarlyEntryPointDeps().isEmpty()) {
                EarlySingletonComponentCreatorGenerator.generate(this.getProcessingEnv());
            }
            if (root.isTestRoot()) {
                ImmutableList rootMetadatas = (ImmutableList)roots.stream().map(test -> RootMetadata.create(test, tree, deps, aliasOfs, this.getProcessingEnv())).collect(DaggerStreams.toImmutableList());
                this.generateTestComponentData(metadataElement, (ImmutableList<RootMetadata>)rootMetadatas, componentNames);
            } else {
                this.generateApplication(root.element());
            }
            this.setProcessingState(metadata, root);
        }
        catch (Exception e) {
            this.processed.add(metadata.name());
            throw e;
        }
    }

    private void setProcessingState(ComponentTreeDepsMetadata metadata, Root root) {
        this.processed.add(metadata.name());
    }

    private void generateComponents(ComponentTreeDepsMetadata metadata, RootMetadata rootMetadata, ComponentNames componentNames) throws IOException {
        RootGenerator.generate(metadata, rootMetadata, componentNames, this.getProcessingEnv());
    }

    private void generateTestComponentData(TypeElement metadataElement, ImmutableList<RootMetadata> rootMetadatas, ComponentNames componentNames) throws IOException {
        for (RootMetadata rootMetadata : rootMetadatas) {
            TypeElement testElement = rootMetadata.testRootMetadata().testElement();
            ProcessorErrors.checkState(testElement.getModifiers().contains((Object)Modifier.PUBLIC), testElement, "Hilt tests must be public, but found: %s", testElement);
            new TestComponentDataGenerator(this.getProcessingEnv(), metadataElement, rootMetadata, componentNames).generate();
        }
    }

    private void generateApplication(TypeElement rootElement) throws IOException {
        if (!HiltCompilerOptions.useAggregatingRootProcessor(this.getProcessingEnv())) {
            AndroidEntryPointMetadata metadata = AndroidEntryPointMetadata.of(this.getProcessingEnv(), rootElement);
            new ApplicationGenerator(this.getProcessingEnv(), metadata).generate();
        }
    }
}

