/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.AggregatedElements;
import dagger.hilt.processor.internal.AnnotationValues;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.root.AutoValue_ComponentTreeDepsMetadata;
import dagger.hilt.processor.internal.root.ir.ComponentTreeDepsIr;
import dagger.internal.codegen.extension.DaggerStreams;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

@AutoValue
abstract class ComponentTreeDepsMetadata {
    ComponentTreeDepsMetadata() {
    }

    abstract ClassName name();

    abstract ImmutableSet<TypeElement> aggregatedRootDeps();

    abstract ImmutableSet<TypeElement> defineComponentDeps();

    abstract ImmutableSet<TypeElement> aliasOfDeps();

    abstract ImmutableSet<TypeElement> aggregatedDeps();

    abstract ImmutableSet<TypeElement> aggregatedUninstallModulesDeps();

    abstract ImmutableSet<TypeElement> aggregatedEarlyEntryPointDeps();

    static ComponentTreeDepsMetadata from(TypeElement element, Elements elements) {
        Preconditions.checkArgument((boolean)Processors.hasAnnotation((Element)element, ClassNames.COMPONENT_TREE_DEPS));
        AnnotationMirror annotationMirror = Processors.getAnnotationMirror((Element)element, ClassNames.COMPONENT_TREE_DEPS);
        ImmutableMap<String, AnnotationValue> values = Processors.getAnnotationValues(elements, annotationMirror);
        return ComponentTreeDepsMetadata.create(ClassName.get((TypeElement)element), AggregatedElements.unwrapProxies(AnnotationValues.getTypeElements((AnnotationValue)values.get((Object)"rootDeps")), elements), AggregatedElements.unwrapProxies(AnnotationValues.getTypeElements((AnnotationValue)values.get((Object)"defineComponentDeps")), elements), AggregatedElements.unwrapProxies(AnnotationValues.getTypeElements((AnnotationValue)values.get((Object)"aliasOfDeps")), elements), AggregatedElements.unwrapProxies(AnnotationValues.getTypeElements((AnnotationValue)values.get((Object)"aggregatedDeps")), elements), AggregatedElements.unwrapProxies(AnnotationValues.getTypeElements((AnnotationValue)values.get((Object)"uninstallModulesDeps")), elements), AggregatedElements.unwrapProxies(AnnotationValues.getTypeElements((AnnotationValue)values.get((Object)"earlyEntryPointDeps")), elements));
    }

    static ComponentTreeDepsMetadata from(ComponentTreeDepsIr ir, Elements elements) {
        return ComponentTreeDepsMetadata.create(ir.getName(), (ImmutableSet<TypeElement>)((ImmutableSet)ir.getRootDeps().stream().map(it -> elements.getTypeElement(it.canonicalName())).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<TypeElement>)((ImmutableSet)ir.getDefineComponentDeps().stream().map(it -> elements.getTypeElement(it.canonicalName())).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<TypeElement>)((ImmutableSet)ir.getAliasOfDeps().stream().map(it -> elements.getTypeElement(it.canonicalName())).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<TypeElement>)((ImmutableSet)ir.getAggregatedDeps().stream().map(it -> elements.getTypeElement(it.canonicalName())).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<TypeElement>)((ImmutableSet)ir.getUninstallModulesDeps().stream().map(it -> elements.getTypeElement(it.canonicalName())).collect(DaggerStreams.toImmutableSet())), (ImmutableSet<TypeElement>)((ImmutableSet)ir.getEarlyEntryPointDeps().stream().map(it -> elements.getTypeElement(it.canonicalName())).collect(DaggerStreams.toImmutableSet())));
    }

    static ComponentTreeDepsMetadata create(ClassName name, ImmutableSet<TypeElement> aggregatedRootDeps, ImmutableSet<TypeElement> defineComponentDeps, ImmutableSet<TypeElement> aliasOfDeps, ImmutableSet<TypeElement> aggregatedDeps, ImmutableSet<TypeElement> aggregatedUninstallModulesDeps, ImmutableSet<TypeElement> aggregatedEarlyEntryPointDeps) {
        return new AutoValue_ComponentTreeDepsMetadata(name, aggregatedRootDeps, defineComponentDeps, aliasOfDeps, aggregatedDeps, aggregatedUninstallModulesDeps, aggregatedEarlyEntryPointDeps);
    }
}

