/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.processor.internal.AggregatedElements;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.root.ComponentTreeDepsMetadata;
import java.io.IOException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

final class ComponentTreeDepsGenerator {
    private final Set<ClassName> generatedProxies = new HashSet<ClassName>();
    private final ProcessingEnvironment env;

    ComponentTreeDepsGenerator(ProcessingEnvironment env) {
        this.env = env;
    }

    void generate(ComponentTreeDepsMetadata metadata) throws IOException {
        ClassName name = metadata.name();
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)name).addAnnotation(this.componentTreeDepsAnnotation(metadata));
        Processors.addGeneratedAnnotation(builder, this.env, ClassNames.ROOT_PROCESSOR.toString());
        JavaFile.builder((String)name.packageName(), (TypeSpec)builder.build()).build().writeTo(this.env.getFiler());
    }

    AnnotationSpec componentTreeDepsAnnotation(ComponentTreeDepsMetadata metadata) throws IOException {
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassNames.COMPONENT_TREE_DEPS);
        this.addDeps(builder, metadata.aggregatedRootDeps(), "rootDeps");
        this.addDeps(builder, metadata.defineComponentDeps(), "defineComponentDeps");
        this.addDeps(builder, metadata.aliasOfDeps(), "aliasOfDeps");
        this.addDeps(builder, metadata.aggregatedDeps(), "aggregatedDeps");
        this.addDeps(builder, metadata.aggregatedUninstallModulesDeps(), "uninstallModulesDeps");
        this.addDeps(builder, metadata.aggregatedEarlyEntryPointDeps(), "earlyEntryPointDeps");
        return builder.build();
    }

    private void addDeps(AnnotationSpec.Builder builder, ImmutableSet<TypeElement> deps, String name) throws IOException {
        for (TypeElement dep : deps) {
            builder.addMember(name, "$T.class", new Object[]{this.maybeWrapInPublicProxy(dep)});
        }
    }

    private ClassName maybeWrapInPublicProxy(TypeElement dep) throws IOException {
        Optional<ClassName> proxyName = AggregatedElements.aggregatedElementProxyName(dep);
        if (proxyName.isPresent()) {
            if (this.generatedProxies.add(proxyName.get()) && this.env.getElementUtils().getTypeElement(proxyName.get().canonicalName()) == null) {
                this.generateProxy(dep, proxyName.get());
            }
            return proxyName.get();
        }
        return ClassName.get((TypeElement)dep);
    }

    private void generateProxy(TypeElement dep, ClassName proxyName) throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)proxyName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.AGGREGATED_ELEMENT_PROXY).addMember("value", "$T.class", new Object[]{dep}).build());
        Processors.addGeneratedAnnotation(builder, this.env, ClassNames.ROOT_PROCESSOR.toString());
        JavaFile.builder((String)proxyName.packageName(), (TypeSpec)builder.build()).build().writeTo(this.env.getFiler());
    }
}

