/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public final class AggregatedElements {
    public static Optional<ClassName> aggregatedElementProxyName(TypeElement aggregatedElement) {
        if (aggregatedElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            return Optional.empty();
        }
        ClassName name = ClassName.get((TypeElement)aggregatedElement);
        return Optional.of(name.peerClass("_" + name.simpleName()));
    }

    public static ImmutableSet<TypeElement> unwrapProxies(ImmutableSet<TypeElement> aggregatedElements, Elements elements) {
        return (ImmutableSet)aggregatedElements.stream().map(aggregatedElement -> AggregatedElements.unwrapProxy(aggregatedElement, elements)).collect(DaggerStreams.toImmutableSet());
    }

    private static TypeElement unwrapProxy(TypeElement element, Elements elements) {
        return Processors.hasAnnotation((Element)element, ClassNames.AGGREGATED_ELEMENT_PROXY) ? Processors.getAnnotationClassValue(elements, Processors.getAnnotationMirror((Element)element, ClassNames.AGGREGATED_ELEMENT_PROXY), "value") : element;
    }

    public static ImmutableSet<TypeElement> from(String aggregatingPackage, ClassName aggregatingAnnotation, Elements elements) {
        PackageElement packageElement = elements.getPackageElement(aggregatingPackage);
        if (packageElement == null) {
            return ImmutableSet.of();
        }
        ImmutableSet aggregatedElements = (ImmutableSet)packageElement.getEnclosedElements().stream().map(MoreElements::asType).filter(element -> !Processors.hasAnnotation((Element)element, ClassNames.AGGREGATED_ELEMENT_PROXY)).collect(DaggerStreams.toImmutableSet());
        ProcessorErrors.checkState(!aggregatedElements.isEmpty(), packageElement, "No dependencies found. Did you remove code in package %s?", packageElement);
        for (TypeElement aggregatedElement : aggregatedElements) {
            ProcessorErrors.checkState(Processors.hasAnnotation((Element)aggregatedElement, aggregatingAnnotation), aggregatedElement, "Expected element, %s, to be annotated with @%s, but only found: %s.", aggregatedElement.getSimpleName(), aggregatingAnnotation, aggregatedElement.getAnnotationMirrors());
        }
        return aggregatedElements;
    }

    private AggregatedElements() {
    }
}

