/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.bindvalue;

import com.google.auto.service.AutoService;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.hilt.android.processor.internal.bindvalue.BindValueGenerator;
import dagger.hilt.android.processor.internal.bindvalue.BindValueMetadata;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.Collection;
import java.util.Map;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

@AutoService(value={Processor.class})
public final class BindValueProcessor
extends BaseProcessor {
    private static final ImmutableSet<ClassName> SUPPORTED_ANNOTATIONS = ImmutableSet.builder().addAll(BindValueMetadata.BIND_VALUE_ANNOTATIONS).addAll(BindValueMetadata.BIND_VALUE_INTO_SET_ANNOTATIONS).addAll(BindValueMetadata.BIND_ELEMENTS_INTO_SET_ANNOTATIONS).addAll(BindValueMetadata.BIND_VALUE_INTO_MAP_ANNOTATIONS).build();
    private final Multimap<TypeElement, Element> testRootMap = ArrayListMultimap.create();

    public ImmutableSet<String> getSupportedAnnotationTypes() {
        return (ImmutableSet)SUPPORTED_ANNOTATIONS.stream().map(TypeName::toString).collect(DaggerStreams.toImmutableSet());
    }

    @Override
    protected void preRoundProcess(RoundEnvironment roundEnv) {
        this.testRootMap.clear();
    }

    @Override
    public void processEach(TypeElement annotation, Element element) throws Exception {
        ClassName annotationClassName = ClassName.get((TypeElement)annotation);
        Element enclosingElement = element.getEnclosingElement();
        ProcessorErrors.checkState(enclosingElement.getKind() == ElementKind.CLASS && Processors.hasAnnotation(enclosingElement, ClassNames.HILT_ANDROID_TEST), enclosingElement, "@%s can only be used within a class annotated with @HiltAndroidTest. Found: %s", annotationClassName.simpleName(), enclosingElement);
        this.testRootMap.put((Object)MoreElements.asType(enclosingElement), (Object)element);
    }

    @Override
    public void postRoundProcess(RoundEnvironment roundEnvironment) throws Exception {
        for (Map.Entry e : this.testRootMap.asMap().entrySet()) {
            BindValueMetadata metadata = BindValueMetadata.create((TypeElement)e.getKey(), (Collection)e.getValue());
            new BindValueGenerator(this.getProcessingEnv(), metadata).generate();
        }
    }

    static ImmutableList<ClassName> getBindValueAnnotations(Element element) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            TypeName tn = AnnotationSpec.get((AnnotationMirror)annotationMirror).type;
            if (!SUPPORTED_ANNOTATIONS.contains((Object)tn)) continue;
            builder.add((Object)((ClassName)tn));
        }
        return builder.build();
    }
}

