/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.migration;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.view.View;
import androidx.activity.ComponentActivity;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import dagger.hilt.android.internal.migration.InjectedByHilt;
import dagger.hilt.internal.Preconditions;

public final class OptionalInjectCheck {
    public static boolean wasInjectedByHilt(@NonNull ComponentActivity activity) {
        return OptionalInjectCheck.check(activity);
    }

    public static boolean wasInjectedByHilt(@NonNull BroadcastReceiver broadcastReceiver) {
        return OptionalInjectCheck.check(broadcastReceiver);
    }

    public static boolean wasInjectedByHilt(@NonNull Fragment fragment) {
        return OptionalInjectCheck.check(fragment);
    }

    public static boolean wasInjectedByHilt(@NonNull Service service) {
        return OptionalInjectCheck.check(service);
    }

    public static boolean wasInjectedByHilt(@NonNull View view) {
        return OptionalInjectCheck.check(view);
    }

    private static boolean check(@NonNull Object obj) {
        Preconditions.checkNotNull((Object)obj);
        Preconditions.checkArgument((boolean)(obj instanceof InjectedByHilt), (String)"'%s' is not an optionally injected android entry point. Check that you have annotated the class with both @AndroidEntryPoint and @OptionalInject.", (Object[])new Object[]{obj.getClass()});
        return ((InjectedByHilt)obj).wasInjectedByHilt();
    }

    private OptionalInjectCheck() {
    }
}

