/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.testing;

import android.app.Application;
import android.content.Context;
import com.google.auto.value.AutoValue;
import dagger.hilt.EntryPoints;
import dagger.hilt.android.internal.Contexts;
import dagger.hilt.android.internal.testing.TestApplicationComponentManagerHolder;
import dagger.hilt.android.testing.AutoValue_OnComponentReadyRunner_EntryPointListener;
import dagger.hilt.internal.GeneratedComponentManager;
import dagger.hilt.internal.Preconditions;
import java.util.ArrayList;
import java.util.List;

public final class OnComponentReadyRunner {
    private final List<EntryPointListener<?>> listeners = new ArrayList();
    private GeneratedComponentManager<?> componentManager;
    private boolean componentHostSet = false;

    public void setComponentManager(GeneratedComponentManager<?> componentManager) {
        Preconditions.checkState((!this.componentHostSet ? 1 : 0) != 0, (String)"Component host was already set.", (Object[])new Object[0]);
        this.componentHostSet = true;
        this.componentManager = componentManager;
        for (EntryPointListener<?> listener : this.listeners) {
            ((EntryPointListener)listener).deliverComponent(componentManager);
        }
    }

    public static <T> void addListener(Context context, Class<T> entryPoint, OnComponentReadyListener<T> listener) {
        Application application = Contexts.getApplication((Context)context.getApplicationContext());
        if (application instanceof TestApplicationComponentManagerHolder) {
            TestApplicationComponentManagerHolder managerHolder = (TestApplicationComponentManagerHolder)application;
            OnComponentReadyRunnerHolder runnerHolder = (OnComponentReadyRunnerHolder)managerHolder.componentManager();
            runnerHolder.getOnComponentReadyRunner().addListenerInternal(entryPoint, listener);
        }
    }

    private <T> void addListenerInternal(Class<T> entryPoint, OnComponentReadyListener<T> listener) {
        if (this.componentHostSet) {
            OnComponentReadyRunner.runListener(this.componentManager, entryPoint, listener);
        } else {
            this.listeners.add(EntryPointListener.create(entryPoint, listener));
        }
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    private static <T> void runListener(GeneratedComponentManager<?> componentManager, Class<T> entryPoint, OnComponentReadyListener<T> listener) {
        try {
            listener.onComponentReady(EntryPoints.get(componentManager, entryPoint));
        }
        catch (Error | RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static interface OnComponentReadyListener<T> {
        public void onComponentReady(T var1) throws Throwable;
    }

    public static interface OnComponentReadyRunnerHolder {
        public OnComponentReadyRunner getOnComponentReadyRunner();
    }

    @AutoValue
    static abstract class EntryPointListener<T> {
        EntryPointListener() {
        }

        static <T> EntryPointListener<T> create(Class<T> entryPoint, OnComponentReadyListener<T> listener) {
            return new AutoValue_OnComponentReadyRunner_EntryPointListener<T>(entryPoint, listener);
        }

        abstract Class<T> entryPoint();

        abstract OnComponentReadyListener<T> listener();

        private void deliverComponent(GeneratedComponentManager<?> object) {
            OnComponentReadyRunner.runListener(object, this.entryPoint(), this.listener());
        }
    }
}

