/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.internal.testing;

import android.content.Context;
import androidx.test.core.app.ApplicationProvider;
import dagger.hilt.android.internal.testing.TestApplicationComponentManager;
import dagger.hilt.android.internal.testing.TestApplicationComponentManagerHolder;
import dagger.hilt.internal.GeneratedComponentManager;
import dagger.hilt.internal.Preconditions;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class MarkThatRulesRanRule
implements TestRule {
    private static final String HILT_ANDROID_APP = "dagger.hilt.android.HiltAndroidApp";
    private static final String HILT_ANDROID_TEST = "dagger.hilt.android.testing.HiltAndroidTest";
    private final Context context = ApplicationProvider.getApplicationContext();
    private final Object testInstance;
    private final boolean autoAddModule;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public MarkThatRulesRanRule(Object testInstance) {
        this.autoAddModule = true;
        this.testInstance = Preconditions.checkNotNull((Object)testInstance);
        Preconditions.checkState((boolean)MarkThatRulesRanRule.hasAnnotation(testInstance, HILT_ANDROID_TEST), (String)"Expected %s to be annotated with @HiltAndroidTest.", (Object[])new Object[]{testInstance.getClass().getName()});
        Preconditions.checkState((boolean)(this.context instanceof GeneratedComponentManager), (String)"Hilt test, %s, must use a Hilt test application but found %s. To fix, configure the test to use HiltTestApplication or a custom Hilt test application generated with @CustomTestApplication.", (Object[])new Object[]{testInstance.getClass().getName(), this.context.getClass().getName()});
        Preconditions.checkState((!MarkThatRulesRanRule.hasAnnotation(this.context, HILT_ANDROID_APP) ? 1 : 0) != 0, (String)"Hilt test, %s, cannot use a @HiltAndroidApp application but found %s. To fix, configure the test to use HiltTestApplication or a custom Hilt test application generated with @CustomTestApplication.", (Object[])new Object[]{testInstance.getClass().getName(), this.context.getClass().getName()});
    }

    public void delayComponentReady() {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (String)"Called delayComponentReady after test execution started", (Object[])new Object[0]);
        this.getTestApplicationComponentManager().delayComponentReady();
    }

    public void componentReady() {
        Preconditions.checkState((boolean)this.started.get(), (String)"Called componentReady before test execution started", (Object[])new Object[0]);
        this.getTestApplicationComponentManager().componentReady();
    }

    public void inject() {
        this.getTestApplicationComponentManager().inject();
    }

    public Statement apply(final Statement base, final Description description) {
        this.started.set(true);
        Preconditions.checkState((boolean)description.getTestClass().isInstance(this.testInstance), (String)"HiltAndroidRule was constructed with an argument that was not an instance of the test class", (Object[])new Object[0]);
        return new Statement(){

            public void evaluate() throws Throwable {
                TestApplicationComponentManager componentManager = MarkThatRulesRanRule.this.getTestApplicationComponentManager();
                try {
                    componentManager.checkStateIsCleared();
                    componentManager.setAutoAddModule(MarkThatRulesRanRule.this.autoAddModule);
                    if (MarkThatRulesRanRule.this.testInstance != null) {
                        componentManager.setTestInstance(MarkThatRulesRanRule.this.testInstance);
                    }
                    componentManager.setHasHiltTestRule(description);
                    base.evaluate();
                    componentManager.verifyDelayedComponentWasMadeReady();
                }
                finally {
                    componentManager.clearState();
                }
            }
        };
    }

    private TestApplicationComponentManager getTestApplicationComponentManager() {
        Preconditions.checkState((boolean)(this.context instanceof TestApplicationComponentManagerHolder), (String)"The context is not an instance of TestApplicationComponentManagerHolder: %s", (Object[])new Object[]{this.context});
        GeneratedComponentManager componentManager = ((TestApplicationComponentManagerHolder)this.context).componentManager();
        Preconditions.checkState((boolean)(componentManager instanceof TestApplicationComponentManager), (String)"Expected TestApplicationComponentManagerHolder to return an instance ofTestApplicationComponentManager", (Object[])new Object[0]);
        return (TestApplicationComponentManager)componentManager;
    }

    private static boolean hasAnnotation(Object obj, String annotationName) {
        for (Annotation annotation : obj.getClass().getAnnotations()) {
            if (!annotation.annotationType().getName().contentEquals(annotationName)) continue;
            return true;
        }
        return false;
    }
}

