/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin;

import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.instrumentation.FramesComputationMode;
import com.android.build.api.instrumentation.InstrumentationParameters;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.Component;
import com.android.build.api.variant.ComponentIdentity;
import com.android.build.api.variant.LibraryAndroidComponentsExtension;
import com.android.build.api.variant.TestAndroidComponentsExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.build.gradle.tasks.JdkImageInput;
import dagger.hilt.android.plugin.HiltCommandLineArgumentProvider;
import dagger.hilt.android.plugin.HiltExtension;
import dagger.hilt.android.plugin.HiltExtensionImpl;
import dagger.hilt.android.plugin.VersionKt;
import dagger.hilt.android.plugin.task.AggregateDepsTask;
import dagger.hilt.android.plugin.transform.AggregatedPackagesTransform;
import dagger.hilt.android.plugin.transform.AndroidEntryPointClassVisitor;
import dagger.hilt.android.plugin.transform.CopyTransform;
import dagger.hilt.android.plugin.util.ConfigurationsKt;
import dagger.hilt.android.plugin.util.StringsKt;
import dagger.hilt.android.plugin.util.TasksKt;
import dagger.hilt.android.plugin.util.VariantsKt;
import dagger.hilt.processor.internal.optionvalues.GradleProjectType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\u0011\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u001d\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f2\u0006\u0010\t\u001a\u00020\u0002H\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J \u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001c\u0010\u0015\u001a\u00020\b2\u0012\u0010\u0016\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J,\u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0016\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Ldagger/hilt/android/plugin/HiltGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "<init>", "(Lorg/gradle/api/provider/ProviderFactory;)V", "apply", "", "project", "configureHilt", "configureDependencyTransforms", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "kotlin.jvm.PlatformType", "(Lorg/gradle/api/Project;)Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "configureCompileClasspath", "hiltExtension", "Ldagger/hilt/android/plugin/HiltExtension;", "configureVariantCompileClasspath", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "configureBytecodeTransformASM", "androidExtension", "Lcom/android/build/api/variant/AndroidComponentsExtension;", "configureAggregatingTask", "configureVariantAggregatingTask", "Lcom/android/build/gradle/BaseExtension;", "configureProcessorFlags", "verifyDependencies", "Companion"})
@SourceDebugExtension(value={"SMAP\nHiltGradlePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiltGradlePlugin.kt\ndagger/hilt/android/plugin/HiltGradlePlugin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,464:1\n1#2:465\n37#3,2:466\n37#3,2:496\n819#4:468\n847#4,2:469\n1360#4:471\n1446#4,2:472\n800#4,11:474\n1549#4:485\n1620#4,3:486\n1448#4,3:489\n1549#4:492\n1620#4,3:493\n766#4:498\n857#4,2:499\n1855#4,2:501\n*S KotlinDebug\n*F\n+ 1 HiltGradlePlugin.kt\ndagger/hilt/android/plugin/HiltGradlePlugin\n*L\n277#1:466,2\n298#1:496,2\n420#1:468\n420#1:469,2\n424#1:471\n424#1:472,2\n425#1:474,11\n425#1:485\n425#1:486,3\n424#1:489,3\n291#1:492\n291#1:493,3\n345#1:498\n345#1:499,2\n346#1:501,2\n*E\n"})
public final class HiltGradlePlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProviderFactory providers;
    private static final Attribute<String> ARTIFACT_TYPE_ATTRIBUTE = Attribute.of((String)"artifactType", String.class);
    @NotNull
    public static final String DAGGER_ARTIFACT_TYPE_VALUE = "jar-for-dagger";
    @NotNull
    public static final String AGGREGATED_HILT_ARTIFACT_TYPE_VALUE = "aggregated-jar-for-hilt";
    @NotNull
    public static final String LIBRARY_GROUP = "com.google.dagger";
    @NotNull
    private static final Lazy<List<String>> gradleSyncProps$delegate = LazyKt.lazy(HiltGradlePlugin::gradleSyncProps_delegate$lambda$58);

    @Inject
    public HiltGradlePlugin(@NotNull ProviderFactory providers) {
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.providers = providers;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Ref.BooleanRef configured = new Ref.BooleanRef();
        project.getPlugins().withId("com.android.base", arg_0 -> HiltGradlePlugin.apply$lambda$1(arg_0 -> HiltGradlePlugin.apply$lambda$0(configured, this, project, arg_0), arg_0));
        project.afterEvaluate(arg_0 -> HiltGradlePlugin.apply$lambda$4(arg_0 -> HiltGradlePlugin.apply$lambda$3(configured, this, arg_0), arg_0));
    }

    private final void configureHilt(Project project) {
        HiltExtension hiltExtension = (HiltExtension)project.getExtensions().create(HiltExtension.class, "hilt", HiltExtensionImpl.class, new Object[0]);
        AndroidComponentsExtension androidExtension = (AndroidComponentsExtension)project.getExtensions().findByType(AndroidComponentsExtension.class);
        if (!(androidExtension != null)) {
            boolean $i$a$-check-HiltGradlePlugin$configureHilt$32 = false;
            String $i$a$-check-HiltGradlePlugin$configureHilt$32 = "Could not find the Android Gradle Plugin (AGP) extension.";
            throw new IllegalStateException($i$a$-check-HiltGradlePlugin$configureHilt$32.toString());
        }
        if (!(androidExtension.getPluginVersion().compareTo(new AndroidPluginVersion(8, 1)) >= 0)) {
            boolean bl = false;
            String string = "The Hilt Android Gradle plugin is only compatible with Android Gradle plugin (AGP) version 8.1.0 or higher (found " + androidExtension.getPluginVersion() + ").";
            throw new IllegalStateException(string.toString());
        }
        this.configureDependencyTransforms(project);
        Intrinsics.checkNotNull((Object)hiltExtension);
        this.configureCompileClasspath(project, hiltExtension);
        this.configureBytecodeTransformASM(androidExtension);
        this.configureAggregatingTask(project, hiltExtension);
        this.configureProcessorFlags(project, hiltExtension, androidExtension);
    }

    private final DependencyHandler configureDependencyTransforms(Project project) {
        DependencyHandler dependencyHandler;
        DependencyHandler $this$configureDependencyTransforms_u24lambda_u2413 = dependencyHandler = project.getDependencies();
        boolean bl = false;
        $this$configureDependencyTransforms_u24lambda_u2413.registerTransform(CopyTransform.class, arg_0 -> HiltGradlePlugin.configureDependencyTransforms$lambda$13$lambda$8(HiltGradlePlugin::configureDependencyTransforms$lambda$13$lambda$7, arg_0));
        $this$configureDependencyTransforms_u24lambda_u2413.registerTransform(CopyTransform.class, arg_0 -> HiltGradlePlugin.configureDependencyTransforms$lambda$13$lambda$10(HiltGradlePlugin::configureDependencyTransforms$lambda$13$lambda$9, arg_0));
        $this$configureDependencyTransforms_u24lambda_u2413.registerTransform(AggregatedPackagesTransform.class, arg_0 -> HiltGradlePlugin.configureDependencyTransforms$lambda$13$lambda$12(HiltGradlePlugin::configureDependencyTransforms$lambda$13$lambda$11, arg_0));
        return dependencyHandler;
    }

    private final void configureCompileClasspath(Project project, HiltExtension hiltExtension) {
        BaseExtension baseExtension = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
        if (baseExtension == null) {
            throw new IllegalStateException("Android BaseExtension not found.".toString());
        }
        BaseExtension androidExtension = baseExtension;
        VariantsKt.forEachRootVariant(androidExtension, (Function1<? super BaseVariant, Unit>)((Function1)arg_0 -> HiltGradlePlugin.configureCompileClasspath$lambda$14(this, project, hiltExtension, arg_0)));
    }

    private final void configureVariantCompileClasspath(Project project, HiltExtension hiltExtension, BaseVariant variant) {
        String string;
        if (!hiltExtension.getEnableExperimentalClasspathAggregation() || hiltExtension.getEnableAggregatingTask()) {
            return;
        }
        if (HiltGradlePlugin.Companion.isGradleSyncRunning(project)) {
            return;
        }
        Configuration runtimeConfiguration = variant instanceof TestVariant ? ((TestVariant)variant).getTestedVariant().getRuntimeConfiguration() : variant.getRuntimeConfiguration();
        ArtifactView artifactView = runtimeConfiguration.getIncoming().artifactView(arg_0 -> HiltGradlePlugin.configureVariantCompileClasspath$lambda$18(arg_0 -> HiltGradlePlugin.configureVariantCompileClasspath$lambda$17(project, arg_0), arg_0));
        BaseVariant baseVariant = variant;
        if (baseVariant instanceof TestVariant) {
            String string2 = ((TestVariant)variant).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            string = "androidTest" + StringsKt.capitalize$default(kotlin.text.StringsKt.substringBeforeLast$default((String)string2, (String)"AndroidTest", null, (int)2, null), null, 1, null) + "CompileOnly";
        } else if (baseVariant instanceof UnitTestVariant) {
            String string3 = ((UnitTestVariant)variant).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            string = "test" + StringsKt.capitalize$default(kotlin.text.StringsKt.substringBeforeLast$default((String)string3, (String)"UnitTest", null, (int)2, null), null, 1, null) + "CompileOnly";
        } else {
            string = variant.getName() + "CompileOnly";
        }
        String compileOnlyConfigName = string;
        project.getDependencies().add(compileOnlyConfigName, (Object)artifactView.getFiles());
    }

    private final void configureBytecodeTransformASM(AndroidComponentsExtension<?, ?, ?> androidExtension) {
        VariantsKt.onAllVariants(androidExtension, (Function1<? super Component, Unit>)((Function1)HiltGradlePlugin::configureBytecodeTransformASM$lambda$20));
    }

    private final void configureAggregatingTask(Project project, HiltExtension hiltExtension) {
        BaseExtension baseExtension = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
        if (baseExtension == null) {
            throw new IllegalStateException("Android BaseExtension not found.".toString());
        }
        BaseExtension androidExtension = baseExtension;
        VariantsKt.forEachRootVariant(androidExtension, (Function1<? super BaseVariant, Unit>)((Function1)arg_0 -> HiltGradlePlugin.configureAggregatingTask$lambda$21(this, project, hiltExtension, androidExtension, arg_0)));
    }

    private final void configureVariantAggregatingTask(Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        if (!hiltExtension.getEnableAggregatingTask()) {
            return;
        }
        ConfigurationContainer configurationContainer = project.getConfigurations();
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Object[] objectArray = configurationContainer.create("hiltCompileOnly" + StringsKt.capitalize$default(string, null, 1, null));
        Object $this$configureVariantAggregatingTask_u24lambda_u2422 = (Configuration)objectArray;
        boolean bl = false;
        $this$configureVariantAggregatingTask_u24lambda_u2422.setDescription("Hilt aggregated compile only dependencies for '" + variant.getName() + "'");
        $this$configureVariantAggregatingTask_u24lambda_u2422.setCanBeConsumed(false);
        $this$configureVariantAggregatingTask_u24lambda_u2422.setCanBeResolved(true);
        $this$configureVariantAggregatingTask_u24lambda_u2422.setVisible(false);
        Configuration hiltCompileConfiguration = (Configuration)objectArray;
        objectArray = new Object[]{variant.getJavaCompileProvider().map(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$24(HiltGradlePlugin::configureVariantAggregatingTask$lambda$23, arg_0))};
        project.getDependencies().add(hiltCompileConfiguration.getName(), (Object)project.files(objectArray));
        objectArray = new Object[]{variant.getJavaCompileProvider().map(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$26(HiltGradlePlugin::configureVariantAggregatingTask$lambda$25, arg_0))};
        project.getDependencies().add(hiltCompileConfiguration.getName(), (Object)project.files(objectArray));
        ConfigurationContainer configurationContainer2 = project.getConfigurations();
        String string2 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        Object config = $this$configureVariantAggregatingTask_u24lambda_u2422 = configurationContainer2.create("hiltAnnotationProcessor" + StringsKt.capitalize$default(string2, null, 1, null));
        boolean $i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$hiltAnnotationProcessorConfiguration$22 = false;
        config.setDescription("Hilt annotation processor classpath for '" + variant.getName() + "'");
        config.setCanBeConsumed(false);
        config.setCanBeResolved(true);
        config.setVisible(false);
        Object[] objectArray2 = CollectionsKt.createListBuilder();
        Configuration[] $this$configureVariantAggregatingTask_u24lambda_u2435_u24lambda_u2434 = objectArray2;
        boolean bl2 = false;
        Configuration configuration = variant.getAnnotationProcessorConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getAnnotationProcessorConfiguration(...)");
        $this$configureVariantAggregatingTask_u24lambda_u2435_u24lambda_u2434.add(configuration);
        project.getPlugins().withId("kotlin-kapt", arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$35$lambda$34$lambda$29(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$35$lambda$34$lambda$28(project, variant, (List)$this$configureVariantAggregatingTask_u24lambda_u2435_u24lambda_u2434, arg_0), arg_0));
        project.getPlugins().withId("com.google.devtools.ksp", arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$35$lambda$34$lambda$33(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$35$lambda$34$lambda$32(project, variant, (List)$this$configureVariantAggregatingTask_u24lambda_u2435_u24lambda_u2434, arg_0), arg_0));
        List apConfigurations = CollectionsKt.build((List)objectArray2);
        Collection $this$toTypedArray$iv = apConfigurations;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray2 = thisCollection$iv.toArray(new Configuration[0]);
        config.extendsFrom(Arrays.copyOf(objectArray2, objectArray2.length));
        project.getDependencies().add(config.getName(), (Object)("com.google.dagger:hilt-compiler:" + VersionKt.getHILT_VERSION()));
        Object hiltAnnotationProcessorConfiguration = $this$configureVariantAggregatingTask_u24lambda_u2422;
        TaskContainer taskContainer = project.getTasks();
        String string3 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        TaskProvider aggregatingTask = taskContainer.register("hiltAggregateDeps" + StringsKt.capitalize$default(string3, null, 1, null), AggregateDepsTask.class, arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$42(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$41(project, variant, androidExtension, hiltExtension, hiltCompileConfiguration, arg_0), arg_0));
        Object[] $i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$hiltAnnotationProcessorConfiguration$22 = new Object[1];
        File file = project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildDir(...)");
        $i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$hiltAnnotationProcessorConfiguration$22[0] = FilesKt.resolve((File)file, (String)("intermediates/hilt/component_classes/" + variant.getName() + "/"));
        ConfigurableFileCollection componentClasses = project.files($i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$hiltAnnotationProcessorConfiguration$22);
        TaskContainer taskContainer2 = project.getTasks();
        String string4 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        TaskProvider componentsJavaCompileTask = taskContainer2.register("hiltJavaCompile" + StringsKt.capitalize$default(string4, null, 1, null), JavaCompile.class, arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$52(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$51(aggregatingTask, variant, androidExtension, componentClasses, project, hiltCompileConfiguration, (Configuration)hiltAnnotationProcessorConfiguration, arg_0), arg_0));
        objectArray2 = new Object[]{componentsJavaCompileTask};
        componentClasses.builtBy(objectArray2);
        variant.registerPostJavacGeneratedBytecode((FileCollection)componentClasses);
    }

    private final void configureProcessorFlags(Project project, HiltExtension hiltExtension, AndroidComponentsExtension<?, ?, ?> androidExtension) {
        GradleProjectType gradleProjectType;
        AndroidComponentsExtension<?, ?, ?> androidComponentsExtension = androidExtension;
        if (androidComponentsExtension instanceof ApplicationAndroidComponentsExtension) {
            gradleProjectType = GradleProjectType.APP;
        } else if (androidComponentsExtension instanceof LibraryAndroidComponentsExtension) {
            gradleProjectType = GradleProjectType.LIBRARY;
        } else if (androidComponentsExtension instanceof TestAndroidComponentsExtension) {
            gradleProjectType = GradleProjectType.TEST;
        } else {
            throw new IllegalStateException(("Hilt plugin does not know how to configure '" + this + "'").toString());
        }
        GradleProjectType projectType = gradleProjectType;
        VariantsKt.onAllVariants(androidExtension, (Function1<? super Component, Unit>)((Function1)arg_0 -> HiltGradlePlugin.configureProcessorFlags$lambda$54(project, projectType, hiltExtension, arg_0)));
    }

    /*
     * Unable to fully structure code
     */
    private final void verifyDependencies(Project project) {
        if (project.getState().getFailure() != null) {
            return;
        }
        v0 = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getConfigurations(...)");
        $this$filterNot$iv = (Iterable)v0;
        $i$f$filterNot = false;
        var5_4 = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Configuration)element$iv$iv;
            $i$a$-filterNot-HiltGradlePlugin$verifyDependencies$dependencies$1 = false;
            v1 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
            if (kotlin.text.StringsKt.startsWith$default((String)v1, (String)"hiltAnnotationProcessor", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getName(...)");
            if (kotlin.text.StringsKt.startsWith$default((String)v2, (String)"hiltCompileOnly", (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            if (v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$filterNotTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            configuration = (Configuration)element$iv$iv;
            $i$a$-flatMap-HiltGradlePlugin$verifyDependencies$dependencies$2 = false;
            v4 = configuration.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getDependencies(...)");
            $this$filterIsInstance$iv = (Iterable)v4;
            $i$f$filterIsInstance = false;
            var14_13 = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterIsInstanceTo = false;
            for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof ExternalDependency)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterIsInstanceTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var19_18 = (ExternalDependency)item$iv$iv;
                var20_19 = destination$iv$iv;
                $i$a$-map-HiltGradlePlugin$verifyDependencies$dependencies$2$1 = false;
                var20_19.add(TuplesKt.to((Object)dependency.getGroup(), (Object)dependency.getName()));
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        dependencies = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!dependencies.contains(TuplesKt.to((Object)"com.google.dagger", (Object)"hilt-android"))) {
            throw new IllegalStateException(HiltGradlePlugin.verifyDependencies$getMissingDepMsg("com.google.dagger:hilt-android").toString());
        }
        if (!dependencies.contains(TuplesKt.to((Object)"com.google.dagger", (Object)"hilt-android-compiler")) && !dependencies.contains(TuplesKt.to((Object)"com.google.dagger", (Object)"hilt-compiler"))) {
            throw new IllegalStateException(HiltGradlePlugin.verifyDependencies$getMissingDepMsg("com.google.dagger:hilt-compiler").toString());
        }
    }

    private static final Unit apply$lambda$0(Ref.BooleanRef $configured, HiltGradlePlugin this$0, Project $project, Plugin it) {
        $configured.element = true;
        this$0.configureHilt($project);
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit apply$lambda$3(Ref.BooleanRef $configured, HiltGradlePlugin this$0, Project it) {
        if (!$configured.element) {
            boolean bl = false;
            String string = "The Hilt Android Gradle plugin can only be applied to an Android project.";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNull((Object)it);
        this$0.verifyDependencies(it);
        return Unit.INSTANCE;
    }

    private static final void apply$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureDependencyTransforms$lambda$13$lambda$7(TransformSpec spec) {
        spec.getFrom().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
        spec.getFrom().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)"android-classes");
        spec.getTo().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)DAGGER_ARTIFACT_TYPE_VALUE);
        return Unit.INSTANCE;
    }

    private static final void configureDependencyTransforms$lambda$13$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureDependencyTransforms$lambda$13$lambda$9(TransformSpec spec) {
        spec.getFrom().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        spec.getTo().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)DAGGER_ARTIFACT_TYPE_VALUE);
        return Unit.INSTANCE;
    }

    private static final void configureDependencyTransforms$lambda$13$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureDependencyTransforms$lambda$13$lambda$11(TransformSpec spec) {
        spec.getFrom().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)DAGGER_ARTIFACT_TYPE_VALUE);
        spec.getTo().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)AGGREGATED_HILT_ARTIFACT_TYPE_VALUE);
        return Unit.INSTANCE;
    }

    private static final void configureDependencyTransforms$lambda$13$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureCompileClasspath$lambda$14(HiltGradlePlugin this$0, Project $project, HiltExtension $hiltExtension, BaseVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this$0.configureVariantCompileClasspath($project, $hiltExtension, variant);
        return Unit.INSTANCE;
    }

    private static final boolean configureVariantCompileClasspath$lambda$17$lambda$15(Project $project, ComponentIdentifier identifier) {
        return identifier instanceof ProjectComponentIdentifier ? !Intrinsics.areEqual((Object)((ProjectComponentIdentifier)identifier).getProjectName(), (Object)$project.getName()) : true;
    }

    private static final boolean configureVariantCompileClasspath$lambda$17$lambda$16(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit configureVariantCompileClasspath$lambda$17(Project $project, ArtifactView.ViewConfiguration view) {
        view.getAttributes().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)DAGGER_ARTIFACT_TYPE_VALUE);
        view.componentFilter(arg_0 -> HiltGradlePlugin.configureVariantCompileClasspath$lambda$17$lambda$16(arg_0 -> HiltGradlePlugin.configureVariantCompileClasspath$lambda$17$lambda$15($project, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void configureVariantCompileClasspath$lambda$18(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureBytecodeTransformASM$lambda$20$lambda$19(InstrumentationParameters.None it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Unit configureBytecodeTransformASM$lambda$20(Component variantComponent) {
        Intrinsics.checkNotNullParameter((Object)variantComponent, (String)"variantComponent");
        variantComponent.getInstrumentation().transformClassesWith(AndroidEntryPointClassVisitor.Factory.class, InstrumentationScope.PROJECT, HiltGradlePlugin::configureBytecodeTransformASM$lambda$20$lambda$19);
        variantComponent.getInstrumentation().setAsmFramesComputationMode(FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_METHODS);
        return Unit.INSTANCE;
    }

    private static final Unit configureAggregatingTask$lambda$21(HiltGradlePlugin this$0, Project $project, HiltExtension $hiltExtension, BaseExtension $androidExtension, BaseVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this$0.configureVariantAggregatingTask($project, $hiltExtension, $androidExtension, variant);
        return Unit.INSTANCE;
    }

    private static final FileCollection configureVariantAggregatingTask$lambda$23(JavaCompile it) {
        return it.getClasspath();
    }

    private static final FileCollection configureVariantAggregatingTask$lambda$24(Function1 $tmp0, Object in) {
        return (FileCollection)$tmp0.invoke(in);
    }

    private static final Directory configureVariantAggregatingTask$lambda$25(JavaCompile it) {
        return (Directory)it.getDestinationDirectory().get();
    }

    private static final Directory configureVariantAggregatingTask$lambda$26(Function1 $tmp0, Object in) {
        return (Directory)$tmp0.invoke(in);
    }

    private static final Unit configureVariantAggregatingTask$lambda$35$lambda$34$lambda$28(Project $project, BaseVariant $variant, List $this_buildList, Plugin it) {
        block0: {
            Configuration configuration = (Configuration)$project.getConfigurations().findByName(ConfigurationsKt.getKaptConfigName($variant));
            if (configuration == null) break block0;
            Configuration it2 = configuration;
            boolean bl = false;
            $this_buildList.add(it2);
        }
        return Unit.INSTANCE;
    }

    private static final void configureVariantAggregatingTask$lambda$35$lambda$34$lambda$29(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureVariantAggregatingTask$lambda$35$lambda$34$lambda$32(Project $project, BaseVariant $variant, List $this_buildList, Plugin it) {
        block1: {
            Configuration it2;
            Configuration configuration = (Configuration)$project.getConfigurations().findByName("ksp");
            if (configuration != null) {
                it2 = configuration;
                boolean bl = false;
                $this_buildList.add(it2);
            }
            Configuration configuration2 = (Configuration)$project.getConfigurations().findByName(ConfigurationsKt.getKspConfigName($variant));
            if (configuration2 == null) break block1;
            it2 = configuration2;
            boolean bl = false;
            $this_buildList.add(it2);
        }
        return Unit.INSTANCE;
    }

    private static final void configureVariantAggregatingTask$lambda$35$lambda$34$lambda$33(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit configureVariantAggregatingTask$getInputClasspath$lambda$39$lambda$37(String $artifactAttributeValue, ArtifactView.ViewConfiguration view) {
        view.getAttributes().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)$artifactAttributeValue);
        return Unit.INSTANCE;
    }

    private static final void configureVariantAggregatingTask$getInputClasspath$lambda$39$lambda$38(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConfigurableFileCollection configureVariantAggregatingTask$getInputClasspath(BaseVariant $variant, Configuration hiltCompileConfiguration, Project $project, String artifactAttributeValue) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable;
        List $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2436 = iterable = CollectionsKt.createListBuilder();
        boolean $i$a$-buildList-HiltGradlePlugin$configureVariantAggregatingTask$getInputClasspath$22 = false;
        if ($variant instanceof TestVariant) {
            Configuration configuration = ((TestVariant)$variant).getTestedVariant().getRuntimeConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getRuntimeConfiguration(...)");
            $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2436.add(configuration);
        }
        Configuration configuration = $variant.getRuntimeConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getRuntimeConfiguration(...)");
        $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2436.add(configuration);
        Intrinsics.checkNotNull((Object)hiltCompileConfiguration);
        $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2436.add(hiltCompileConfiguration);
        iterable = CollectionsKt.build((List)iterable);
        boolean $i$f$map = false;
        void $i$a$-buildList-HiltGradlePlugin$configureVariantAggregatingTask$getInputClasspath$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void configuration2;
            Configuration configuration3 = (Configuration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(configuration2.getIncoming().artifactView(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath$lambda$39$lambda$38(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath$lambda$39$lambda$37(artifactAttributeValue, arg_0), arg_0)).getFiles());
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        Collection $this$toTypedArray$iv = it;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FileCollection[] fileCollectionArray = thisCollection$iv.toArray(new FileCollection[0]);
        return $project.files((Object[])Arrays.copyOf(fileCollectionArray, fileCollectionArray.length));
    }

    private static final Unit configureVariantAggregatingTask$lambda$41(Project $project, BaseVariant $variant, BaseExtension $androidExtension, HiltExtension $hiltExtension, Configuration $hiltCompileConfiguration, AggregateDepsTask it) {
        it.getCompileClasspath().setFrom((Iterable)HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath($variant, $hiltCompileConfiguration, $project, AGGREGATED_HILT_ARTIFACT_TYPE_VALUE));
        DirectoryProperty directoryProperty = it.getOutputDir();
        File file = $project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildDir(...)");
        directoryProperty.set($project.file((Object)FilesKt.resolve((File)file, (String)("generated/hilt/component_trees/" + $variant.getName() + "/"))));
        it.getTestEnvironment().set((Object)($variant instanceof TestVariant || $variant instanceof UnitTestVariant || $androidExtension instanceof TestExtension ? 1 : 0));
        it.getCrossCompilationRootValidationDisabled().set((Object)$hiltExtension.getDisableCrossCompilationRootValidation());
        it.getAsmApiVersion().set((Object)589824);
        return Unit.INSTANCE;
    }

    private static final void configureVariantAggregatingTask$lambda$42(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final FileTree configureVariantAggregatingTask$lambda$51$lambda$43(AggregateDepsTask it) {
        return it.getOutputDir().getAsFileTree();
    }

    private static final FileTree configureVariantAggregatingTask$lambda$51$lambda$44(Function1 $tmp0, Object in) {
        return (FileTree)$tmp0.invoke(in);
    }

    private static final FileCollection configureVariantAggregatingTask$lambda$51$lambda$45(Project $project, JavaCompile it) {
        FileCollection fileCollection = it.getOptions().getBootstrapClasspath();
        if (fileCollection == null) {
            fileCollection = (FileCollection)$project.files(new Object[0]);
        }
        return fileCollection;
    }

    private static final FileCollection configureVariantAggregatingTask$lambda$51$lambda$46(Function1 $tmp0, Object in) {
        return (FileCollection)$tmp0.invoke(in);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit configureVariantAggregatingTask$lambda$51(TaskProvider $aggregatingTask, BaseVariant $variant, BaseExtension $androidExtension, ConfigurableFileCollection $componentClasses, Project $project, Configuration $hiltCompileConfiguration, Configuration $hiltAnnotationProcessorConfiguration, JavaCompile compileTask) {
        CompileOptions compileOptions;
        compileTask.setSource((FileTree)$aggregatingTask.map(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$51$lambda$44(HiltGradlePlugin::configureVariantAggregatingTask$lambda$51$lambda$43, arg_0)).get());
        FileCollection mainBootstrapClasspath = (FileCollection)$variant.getJavaCompileProvider().map(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$51$lambda$46(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$51$lambda$45($project, arg_0), arg_0)).get();
        if (JavaVersion.current().isJava9Compatible() && $androidExtension.getCompileOptions().getTargetCompatibility().isJava9Compatible()) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            compileTask.setClasspath(HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath($variant, $hiltCompileConfiguration, $project, DAGGER_ARTIFACT_TYPE_VALUE).plus(mainBootstrapClasspath));
            JavaCompile originalCompileTask = (JavaCompile)$variant.getJavaCompileProvider().get();
            boolean bl = false;
            List list = originalCompileTask.getOptions().getCompilerArgumentProviders();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCompilerArgumentProviders(...)");
            Iterable iterable = list;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CommandLineArgumentProvider it = (CommandLineArgumentProvider)element$iv$iv;
                boolean bl2 = false;
                if (!(it instanceof HiltCommandLineArgumentProvider || it instanceof JdkImageInput)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CommandLineArgumentProvider it = (CommandLineArgumentProvider)element$iv;
                boolean bl3 = false;
                compileTask.getOptions().getCompilerArgumentProviders().add(it);
            }
            compileTask.getOptions().getCompilerArgs().add("-XDstringConcat=inline");
        } else {
            compileTask.setClasspath((FileCollection)HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath($variant, $hiltCompileConfiguration, $project, DAGGER_ARTIFACT_TYPE_VALUE));
            compileTask.getOptions().setBootstrapClasspath(mainBootstrapClasspath);
        }
        compileTask.getDestinationDirectory().set($componentClasses.getSingleFile());
        CompileOptions $this$configureVariantAggregatingTask_u24lambda_u2451_u24lambda_u2450 = compileOptions = compileTask.getOptions();
        boolean bl = false;
        $this$configureVariantAggregatingTask_u24lambda_u2451_u24lambda_u2450.setAnnotationProcessorPath((FileCollection)$hiltAnnotationProcessorConfiguration);
        DirectoryProperty directoryProperty = $this$configureVariantAggregatingTask_u24lambda_u2451_u24lambda_u2450.getGeneratedSourceOutputDirectory();
        File file = $project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildDir(...)");
        directoryProperty.set($project.file((Object)FilesKt.resolve((File)file, (String)("generated/hilt/component_sources/" + $variant.getName() + "/"))));
        if (JavaVersion.current().isJava8Compatible() && $androidExtension.getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
            $this$configureVariantAggregatingTask_u24lambda_u2451_u24lambda_u2450.getCompilerArgs().add("-parameters");
        }
        $this$configureVariantAggregatingTask_u24lambda_u2451_u24lambda_u2450.getCompilerArgs().add("-Adagger.fastInit=enabled");
        $this$configureVariantAggregatingTask_u24lambda_u2451_u24lambda_u2450.getCompilerArgs().add("-Adagger.hilt.internal.useAggregatingRootProcessor=false");
        $this$configureVariantAggregatingTask_u24lambda_u2451_u24lambda_u2450.getCompilerArgs().add("-Adagger.hilt.android.internal.disableAndroidSuperclassValidation=true");
        $this$configureVariantAggregatingTask_u24lambda_u2451_u24lambda_u2450.setEncoding($androidExtension.getCompileOptions().getEncoding());
        compileTask.setSourceCompatibility($androidExtension.getCompileOptions().getSourceCompatibility().toString());
        compileTask.setTargetCompatibility($androidExtension.getCompileOptions().getTargetCompatibility().toString());
        return Unit.INSTANCE;
    }

    private static final void configureVariantAggregatingTask$lambda$52(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final HiltCommandLineArgumentProvider configureProcessorFlags$lambda$54$lambda$53(GradleProjectType $projectType, HiltExtension $hiltExtension, Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        return new HiltCommandLineArgumentProvider(TasksKt.isKspTask(task), $projectType, $hiltExtension.getEnableAggregatingTask(), $hiltExtension.getDisableCrossCompilationRootValidation());
    }

    private static final Unit configureProcessorFlags$lambda$54(Project $project, GradleProjectType $projectType, HiltExtension $hiltExtension, Component variantComponent) {
        Intrinsics.checkNotNullParameter((Object)variantComponent, (String)"variantComponent");
        Function1 argsProducer = arg_0 -> HiltGradlePlugin.configureProcessorFlags$lambda$54$lambda$53($projectType, $hiltExtension, arg_0);
        TasksKt.addJavaTaskProcessorOptions($project, (ComponentIdentity)variantComponent, (Function1<? super Task, ? extends CommandLineArgumentProvider>)argsProducer);
        TasksKt.addKaptTaskProcessorOptions($project, (ComponentIdentity)variantComponent, (Function1<? super Task, ? extends CommandLineArgumentProvider>)argsProducer);
        TasksKt.addKspTaskProcessorOptions($project, (ComponentIdentity)variantComponent, (Function1<? super Task, ? extends CommandLineArgumentProvider>)argsProducer);
        return Unit.INSTANCE;
    }

    private static final String verifyDependencies$getMissingDepMsg(String depCoordinate) {
        return "The Hilt Android Gradle plugin is applied but no " + depCoordinate + " dependency was found.";
    }

    private static final List gradleSyncProps_delegate$lambda$58() {
        Object[] objectArray = new String[]{"android.injected.build.model.v2", "android.injected.build.model.only", "android.injected.build.model.only.advanced"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002R4\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Ldagger/hilt/android/plugin/HiltGradlePlugin$Companion;", "", "<init>", "()V", "ARTIFACT_TYPE_ATTRIBUTE", "Lorg/gradle/api/attributes/Attribute;", "", "kotlin.jvm.PlatformType", "Lorg/gradle/api/attributes/Attribute;", "DAGGER_ARTIFACT_TYPE_VALUE", "AGGREGATED_HILT_ARTIFACT_TYPE_VALUE", "LIBRARY_GROUP", "isGradleSyncRunning", "", "Lorg/gradle/api/Project;", "gradleSyncProps", "", "getGradleSyncProps", "()Ljava/util/List;", "gradleSyncProps$delegate", "Lkotlin/Lazy;"})
    @SourceDebugExtension(value={"SMAP\nHiltGradlePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiltGradlePlugin.kt\ndagger/hilt/android/plugin/HiltGradlePlugin$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,464:1\n1747#2,3:465\n*S KotlinDebug\n*F\n+ 1 HiltGradlePlugin.kt\ndagger/hilt/android/plugin/HiltGradlePlugin$Companion\n*L\n451#1:465,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isGradleSyncRunning(Project $this$isGradleSyncRunning) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.getGradleSyncProps();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String property = (String)element$iv;
                        boolean bl2 = false;
                        Object object = $this$isGradleSyncRunning.getProviders().gradleProperty(property).map(arg_0 -> Companion.isGradleSyncRunning$lambda$2$lambda$1(Companion::isGradleSyncRunning$lambda$2$lambda$0, arg_0)).orElse((Object)false).get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        if (!((Boolean)object).booleanValue()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final List<String> getGradleSyncProps() {
            Lazy lazy = gradleSyncProps$delegate;
            return (List)lazy.getValue();
        }

        private static final Boolean isGradleSyncRunning$lambda$2$lambda$0(String it) {
            return Boolean.parseBoolean(it);
        }

        private static final Boolean isGradleSyncRunning$lambda$2$lambda$1(Function1 $tmp0, Object in) {
            return (Boolean)$tmp0.invoke(in);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

