/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.AggregatedElements;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.root.AutoValue_AggregatedRootMetadata;
import dagger.hilt.processor.internal.root.RootType;
import dagger.hilt.processor.internal.root.ir.AggregatedRootIr;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.List;

@AutoValue
abstract class AggregatedRootMetadata {
    AggregatedRootMetadata() {
    }

    public abstract XTypeElement aggregatingElement();

    abstract XTypeElement rootElement();

    abstract XTypeElement originatingRootElement();

    abstract XTypeElement rootAnnotation();

    abstract ClassName rootComponentName();

    abstract boolean allowsSharingComponent();

    @Memoized
    RootType rootType() {
        return RootType.of(this.rootElement());
    }

    static ImmutableSet<AggregatedRootMetadata> from(XProcessingEnv env) {
        return AggregatedRootMetadata.from(AggregatedElements.from("dagger.hilt.internal.aggregatedroot.codegen", ClassNames.AGGREGATED_ROOT, env), env);
    }

    public static ImmutableSet<AggregatedRootMetadata> from(ImmutableSet<XTypeElement> aggregatedElements, XProcessingEnv env) {
        return (ImmutableSet)aggregatedElements.stream().map(aggregatedElement -> AggregatedRootMetadata.create(aggregatedElement, env)).collect(DaggerStreams.toImmutableSet());
    }

    public static AggregatedRootIr toIr(AggregatedRootMetadata metadata) {
        return new AggregatedRootIr(metadata.aggregatingElement().getClassName(), metadata.rootElement().getClassName(), metadata.originatingRootElement().getClassName(), metadata.rootAnnotation().getClassName(), metadata.rootComponentName(), metadata.allowsSharingComponent());
    }

    private static AggregatedRootMetadata create(XTypeElement element, XProcessingEnv env) {
        XAnnotation annotation = element.getAnnotation(ClassNames.AGGREGATED_ROOT);
        XTypeElement rootElement = env.requireTypeElement(annotation.getAsString("root"));
        boolean allowSharingComponent = true;
        return new AutoValue_AggregatedRootMetadata(element, rootElement, env.requireTypeElement(annotation.getAsString("originatingRoot")), annotation.getAsType("rootAnnotation").getTypeElement(), AggregatedRootMetadata.parseClassName(annotation.getAsString("rootComponentPackage"), annotation.getAsStringList("rootComponentSimpleNames")), allowSharingComponent);
    }

    private static ClassName parseClassName(String pkg, List<String> simpleNames) {
        return ClassName.get((String)pkg, (String)simpleNames.get(0), (String[])simpleNames.subList(1, simpleNames.size()).toArray(new String[0]));
    }
}

