/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.definecomponent;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.BaseProcessingStep;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.definecomponent.DefineComponentBuilderMetadatas;
import dagger.hilt.processor.internal.definecomponent.DefineComponentMetadatas;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XRoundEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;

public final class DefineComponentProcessingStep
extends BaseProcessingStep {
    private DefineComponentMetadatas componentMetadatas;
    private DefineComponentBuilderMetadatas componentBuilderMetadatas;

    public DefineComponentProcessingStep(XProcessingEnv env) {
        super(env);
    }

    @Override
    public void preProcess(XProcessingEnv env, XRoundEnv round) {
        this.componentMetadatas = DefineComponentMetadatas.create();
        this.componentBuilderMetadatas = DefineComponentBuilderMetadatas.create(this.componentMetadatas);
    }

    @Override
    public void postProcess(XProcessingEnv env, XRoundEnv round) {
        this.componentMetadatas = null;
        this.componentBuilderMetadatas = null;
    }

    @Override
    protected ImmutableSet<ClassName> annotationClassNames() {
        return ImmutableSet.of((Object)ClassNames.DEFINE_COMPONENT, (Object)ClassNames.DEFINE_COMPONENT_BUILDER);
    }

    @Override
    public void processEach(ClassName annotation, XElement element) {
        if (annotation.equals((Object)ClassNames.DEFINE_COMPONENT)) {
            DefineComponentMetadatas.DefineComponentMetadata metadata = this.componentMetadatas.get(element);
            this.generateFile("component", metadata.component());
        } else if (annotation.equals((Object)ClassNames.DEFINE_COMPONENT_BUILDER)) {
            DefineComponentBuilderMetadatas.DefineComponentBuilderMetadata metadata = this.componentBuilderMetadatas.get(element);
            this.generateFile("builder", metadata.builder());
        } else {
            throw new AssertionError((Object)("Unhandled annotation type: " + annotation.canonicalName()));
        }
    }

    private void generateFile(String member, XTypeElement typeElement) {
        Processors.generateAggregatingClass("dagger.hilt.processor.internal.definecomponent.codegen", AnnotationSpec.builder((ClassName)ClassNames.DEFINE_COMPONENT_CLASSES).addMember(member, "$S", new Object[]{typeElement.getQualifiedName()}).build(), typeElement, this.getClass());
    }
}

