/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ErrorTypeException;
import dagger.hilt.processor.internal.ProcessorErrorHandler;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingStep;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XRoundEnv;
import java.util.Map;
import java.util.Set;

public abstract class BaseProcessingStep
implements XProcessingStep {
    private final ProcessorErrorHandler errorHandler;
    boolean isAnnotationClassNamesOverridden = true;
    private final XProcessingEnv processingEnv;

    public BaseProcessingStep(XProcessingEnv env) {
        this.errorHandler = new ProcessorErrorHandler(env);
        this.processingEnv = env;
    }

    protected final XProcessingEnv processingEnv() {
        return this.processingEnv;
    }

    public final ImmutableSet<String> annotations() {
        ImmutableSet<ClassName> annotationClassNames = this.annotationClassNames();
        if (!this.isAnnotationClassNamesOverridden) {
            return ImmutableSet.of((Object)"*");
        }
        if (annotationClassNames == null || annotationClassNames.isEmpty()) {
            throw new IllegalStateException("annotationClassNames() should return one or more elements.");
        }
        return (ImmutableSet)annotationClassNames.stream().map(ClassName::canonicalName).collect(DaggerStreams.toImmutableSet());
    }

    protected ImmutableSet<ClassName> annotationClassNames() {
        this.isAnnotationClassNamesOverridden = false;
        return ImmutableSet.of();
    }

    protected void processEach(ClassName annotation, XElement element) throws Exception {
    }

    protected void preProcess(XProcessingEnv env, XRoundEnv round) {
    }

    protected void postProcess(XProcessingEnv env, XRoundEnv round) throws Exception {
    }

    public final void preRoundProcess(XProcessingEnv env, XRoundEnv round) {
        this.preProcess(env, round);
    }

    public final void postRoundProcess(XProcessingEnv env, XRoundEnv round) {
        if (this.errorHandler.isEmpty()) {
            try {
                this.postProcess(env, round);
            }
            catch (Exception e) {
                this.errorHandler.recordError(e);
            }
        }
        if (!this.delayErrors() || round.isProcessingOver()) {
            this.errorHandler.checkErrors();
        }
    }

    public final ImmutableSet<XElement> process(XProcessingEnv env, Map<String, ? extends Set<? extends XElement>> elementsByAnnotation, boolean isLastRound) {
        ImmutableSet.Builder elementsToReprocessBuilder = ImmutableSet.builder();
        for (ClassName annotationName : this.annotationClassNames()) {
            Set<? extends XElement> elements = elementsByAnnotation.get(annotationName.canonicalName());
            if (elements == null) continue;
            for (XElement element : elements) {
                try {
                    this.processEach(annotationName, element);
                }
                catch (Exception e) {
                    if (e instanceof ErrorTypeException && !isLastRound) {
                        elementsToReprocessBuilder.add((Object)element);
                        continue;
                    }
                    this.errorHandler.recordError(e);
                }
            }
        }
        return elementsToReprocessBuilder.build();
    }

    protected boolean delayErrors() {
        return false;
    }
}

