/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.MethodSignature;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeParameterElement;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;

public final class ActivityGenerator {
    private static final FieldSpec SAVED_STATE_HANDLE_HOLDER_FIELD = FieldSpec.builder((TypeName)AndroidClassNames.SAVED_STATE_HANDLE_HOLDER, (String)"savedStateHandleHolder", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    private final XProcessingEnv env;
    private final AndroidEntryPointMetadata metadata;
    private final ClassName generatedClassName;

    public ActivityGenerator(XProcessingEnv env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
        this.generatedClassName = metadata.generatedClassName();
    }

    public void generate() throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.generatedClassName.simpleName()).superclass(this.metadata.baseClassName()).addModifiers(this.metadata.generatedClassModifiers());
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)builder, (XElement)this.metadata.element());
        Generators.addGeneratedBaseClassJavadoc(builder, AndroidClassNames.ANDROID_ENTRY_POINT);
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        Generators.copyConstructors(this.metadata.baseElement(), CodeBlock.builder().addStatement("_initHiltInternal()", new Object[0]).build(), builder);
        builder.addMethod(this.init());
        if (!this.metadata.overridesAndroidEntryPointClass()) {
            builder.addField(SAVED_STATE_HANDLE_HOLDER_FIELD).addMethod(ActivityGenerator.initSavedStateHandleHolderMethod()).addMethod(this.onCreateComponentActivity()).addMethod(this.onDestroyComponentActivity());
        }
        this.metadata.baseElement().getTypeParameters().stream().map(XTypeParameterElement::getTypeVariableName).forEachOrdered(arg_0 -> ((TypeSpec.Builder)builder).addTypeVariable(arg_0));
        Generators.addComponentOverride(this.metadata, builder);
        Generators.copyLintAnnotations((XElement)this.metadata.element(), builder);
        Generators.copySuppressAnnotations((XElement)this.metadata.element(), builder);
        Generators.addInjectionMethods(this.metadata, builder);
        if (Processors.isAssignableFrom(this.metadata.baseElement(), AndroidClassNames.COMPONENT_ACTIVITY) && !this.metadata.overridesAndroidEntryPointClass()) {
            builder.addMethod(this.getDefaultViewModelProviderFactory());
        }
        this.env.getFiler().write(JavaFile.builder((String)this.generatedClassName.packageName(), (TypeSpec)builder.build()).build(), XFiler.Mode.Isolating);
    }

    private MethodSpec init() {
        return MethodSpec.methodBuilder((String)"_initHiltInternal").addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("addOnContextAvailableListener($L)", new Object[]{TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)AndroidClassNames.ON_CONTEXT_AVAILABLE_LISTENER).addMethod(MethodSpec.methodBuilder((String)"onContextAvailable").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)AndroidClassNames.CONTEXT, "context", new Modifier[0]).addStatement("inject()", new Object[0]).build()).build()}).build();
    }

    private MethodSpec getDefaultViewModelProviderFactory() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"getDefaultViewModelProviderFactory").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)AndroidClassNames.VIEW_MODEL_PROVIDER_FACTORY);
        if (this.metadata.allowsOptionalInjection()) {
            builder.beginControlFlow("if (!optionalInjectParentUsesHilt(optionalInjectGetParent()))", new Object[0]).addStatement("return super.getDefaultViewModelProviderFactory()", new Object[0]).endControlFlow();
        }
        return builder.addStatement("return $T.getActivityFactory(this, super.getDefaultViewModelProviderFactory())", new Object[]{AndroidClassNames.DEFAULT_VIEW_MODEL_FACTORIES}).build();
    }

    private MethodSpec onCreateComponentActivity() {
        XMethodElement nearestOverrideMethod = ActivityGenerator.requireNearestOverrideMethod(ActivityMethod.ON_CREATE, this.metadata);
        if (nearestOverrideMethod.isFinal()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Do not mark onCreate as final in base Activity class, as Hilt needs to override it to inject SavedStateHandle.", (XElement)nearestOverrideMethod);
        }
        ParameterSpec.Builder parameterBuilder = ParameterSpec.builder((TypeName)AndroidClassNames.BUNDLE, (String)"savedInstanceState", (Modifier[])new Modifier[0]);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"onCreate");
        if (ActivityGenerator.isNullable((XExecutableParameterElement)nearestOverrideMethod.getParameters().get(0))) {
            parameterBuilder.addAnnotation(AndroidClassNames.NULLABLE);
        }
        if (nearestOverrideMethod.hasAnnotation(AndroidClassNames.UI_THREAD)) {
            methodBuilder.addAnnotation(AndroidClassNames.UI_THREAD);
        }
        return methodBuilder.addAnnotation(AndroidClassNames.CALL_SUPER).addAnnotation(Override.class).addModifiers((Iterable)XElements.getModifiers((XExecutableElement)nearestOverrideMethod)).addParameter(parameterBuilder.build()).addStatement("super.onCreate(savedInstanceState)", new Object[0]).addStatement("initSavedStateHandleHolder()", new Object[0]).build();
    }

    private static MethodSpec initSavedStateHandleHolderMethod() {
        return MethodSpec.methodBuilder((String)"initSavedStateHandleHolder").addModifiers(new Modifier[]{Modifier.PRIVATE}).beginControlFlow("if (getApplication() instanceof $T)", new Object[]{ClassNames.GENERATED_COMPONENT_MANAGER}).addStatement("$N = componentManager().getSavedStateHandleHolder()", new Object[]{SAVED_STATE_HANDLE_HOLDER_FIELD}).beginControlFlow("if ($N.isInvalid())", new Object[]{SAVED_STATE_HANDLE_HOLDER_FIELD}).addStatement("$N.setExtras(getDefaultViewModelCreationExtras())", new Object[]{SAVED_STATE_HANDLE_HOLDER_FIELD}).endControlFlow().endControlFlow().build();
    }

    private static boolean isNullable(XExecutableParameterElement element) {
        return ActivityGenerator.hasNullableAnnotation((XAnnotated)element) || ActivityGenerator.hasNullableAnnotation((XAnnotated)element.getType());
    }

    private static boolean hasNullableAnnotation(XAnnotated element) {
        return element.getAllAnnotations().stream().anyMatch(annotation -> annotation.getClassName().simpleName().equals("Nullable"));
    }

    private MethodSpec onDestroyComponentActivity() {
        XMethodElement nearestOverrideMethod = ActivityGenerator.requireNearestOverrideMethod(ActivityMethod.ON_DESTROY, this.metadata);
        if (nearestOverrideMethod.isFinal()) {
            this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, "Do not mark onDestroy as final in base Activity class, as Hilt needs to override it to clean up SavedStateHandle.", (XElement)nearestOverrideMethod);
        }
        return MethodSpec.methodBuilder((String)"onDestroy").addAnnotation(Override.class).addModifiers((Iterable)XElements.getModifiers((XExecutableElement)nearestOverrideMethod)).addStatement("super.onDestroy()", new Object[0]).beginControlFlow("if ($N != null)", new Object[]{SAVED_STATE_HANDLE_HOLDER_FIELD}).addStatement("$N.clear()", new Object[]{SAVED_STATE_HANDLE_HOLDER_FIELD}).endControlFlow().build();
    }

    private static XMethodElement requireNearestOverrideMethod(ActivityMethod activityMethod, AndroidEntryPointMetadata metadata) {
        XMethodElement methodOnAndroidEntryPointElement = metadata.element().getDeclaredMethods().stream().filter(method -> MethodSignature.of((XExecutableElement)method).equals(activityMethod.signature)).findFirst().orElse(null);
        if (methodOnAndroidEntryPointElement != null) {
            return methodOnAndroidEntryPointElement;
        }
        ImmutableList methodOnBaseElement = (ImmutableList)StreamsKt.asStream((Sequence)metadata.baseElement().getAllMethods()).filter(method -> MethodSignature.of((XExecutableElement)method).equals(activityMethod.signature)).collect(DaggerStreams.toImmutableList());
        Preconditions.checkState((methodOnBaseElement.size() >= 1 ? 1 : 0) != 0);
        return (XMethodElement)Iterables.getLast((Iterable)methodOnBaseElement);
    }

    private static enum ActivityMethod {
        ON_CREATE(new TypeName[]{AndroidClassNames.BUNDLE}),
        ON_STOP(new TypeName[0]),
        ON_DESTROY(new TypeName[0]);

        private final MethodSignature signature;

        private ActivityMethod(TypeName ... parameterTypes) {
            String methodName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
            this.signature = MethodSignature.of(methodName, parameterTypes);
        }
    }
}

