/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.kotlin;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.kotlin.KotlinMetadataFactory;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Collection;
import javax.inject.Inject;

public final class KotlinMetadataUtil {
    private final KotlinMetadataFactory metadataFactory;

    @Inject
    KotlinMetadataUtil(KotlinMetadataFactory metadataFactory) {
        this.metadataFactory = metadataFactory;
    }

    public boolean hasMetadata(XElement element) {
        return XElements.closestEnclosingTypeElement((XElement)element).hasAnnotation(ClassNames.KOTLIN_METADATA);
    }

    public ImmutableList<XAnnotation> getAnnotationsAnnotatedWith(XElement element, ClassName annotationName) {
        return (ImmutableList)this.getAnnotations(element).stream().filter(annotation -> annotation.getTypeElement().hasAnnotation(annotationName)).collect(DaggerStreams.toImmutableList());
    }

    private ImmutableList<XAnnotation> getAnnotations(XElement element) {
        ImmutableList annotations = ImmutableList.copyOf((Collection)element.getAllAnnotations());
        ImmutableList<XAnnotation> syntheticAnnotations = this.getSyntheticPropertyAnnotations(element);
        if (syntheticAnnotations.isEmpty()) {
            return annotations;
        }
        ImmutableSet syntheticAnnotationClassNames = (ImmutableSet)syntheticAnnotations.stream().map(XAnnotations::getClassName).collect(DaggerStreams.toImmutableSet());
        ImmutableSet annotationEquivalenceWrappers = (ImmutableSet)annotations.stream().filter(annotation -> syntheticAnnotationClassNames.contains((Object)annotation.getClassName())).map(arg_0 -> ((Equivalence)XAnnotations.equivalence()).wrap(arg_0)).collect(DaggerStreams.toImmutableSet());
        ImmutableList uniqueSyntheticAnnotations = (ImmutableList)syntheticAnnotations.stream().map(arg_0 -> ((Equivalence)XAnnotations.equivalence()).wrap(arg_0)).filter(wrapper -> !annotationEquivalenceWrappers.contains(wrapper)).map(Equivalence.Wrapper::get).collect(DaggerStreams.toImmutableList());
        return uniqueSyntheticAnnotations.isEmpty() ? annotations : ImmutableList.builder().addAll((Iterable)annotations).addAll((Iterable)uniqueSyntheticAnnotations).build();
    }

    private ImmutableList<XAnnotation> getSyntheticPropertyAnnotations(XElement element) {
        if (!XElementKt.isField((XElement)element) || XElements.isStatic((XElement)element)) {
            return ImmutableList.of();
        }
        XFieldElement field = XElements.asField((XElement)element);
        return this.hasMetadata((XElement)field) ? this.metadataFactory.create((XElement)field).getSyntheticAnnotationMethod(field).map(XAnnotated::getAllAnnotations).map(ImmutableList::copyOf).orElse(ImmutableList.of()) : ImmutableList.of();
    }

    public boolean containsConstructorWithDefaultParam(XTypeElement typeElement) {
        return this.hasMetadata((XElement)typeElement) && this.metadataFactory.create((XElement)typeElement).containsConstructorWithDefaultParam();
    }
}

