/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.spi.shaded.androidx.room.compiler.processing.JavaPoetExtKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import java.io.IOException;
import javax.lang.model.element.Modifier;

public final class InjectorEntryPointGenerator {
    private final XProcessingEnv env;
    private final AndroidEntryPointMetadata metadata;

    public InjectorEntryPointGenerator(XProcessingEnv env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
    }

    public void generate() throws IOException {
        ClassName name = this.metadata.injectorClassName();
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)name.simpleName()).addAnnotation(Processors.getOriginatingElementAnnotation(this.metadata.element())).addAnnotation(ClassNames.GENERATED_ENTRY_POINT).addAnnotation(this.metadata.injectorInstallInAnnotation()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(MethodSpec.methodBuilder((String)this.metadata.injectMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)this.metadata.elementClassName(), Processors.upperToLowerCamel(this.metadata.elementClassName().simpleName()), new Modifier[0]).build());
        JavaPoetExtKt.addOriginatingElement((TypeSpec.Builder)builder, (XElement)this.metadata.element());
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        Generators.copyLintAnnotations((XElement)this.metadata.element(), builder);
        Generators.copySuppressAnnotations((XElement)this.metadata.element(), builder);
        this.env.getFiler().write(JavaFile.builder((String)name.packageName(), (TypeSpec)builder.build()).build(), XFiler.Mode.Isolating);
    }
}

