/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.Generators;
import dagger.hilt.processor.internal.Processors;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

public final class ServiceGenerator {
    private final ProcessingEnvironment env;
    private final AndroidEntryPointMetadata metadata;
    private final ClassName generatedClassName;

    public ServiceGenerator(ProcessingEnvironment env, AndroidEntryPointMetadata metadata) {
        this.env = env;
        this.metadata = metadata;
        this.generatedClassName = metadata.generatedClassName();
    }

    public void generate() throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)this.generatedClassName.simpleName()).addOriginatingElement((Element)this.metadata.element()).superclass(this.metadata.baseClassName()).addModifiers(this.metadata.generatedClassModifiers()).addMethods(this.baseClassConstructors()).addMethod(this.onCreateMethod());
        Generators.addGeneratedBaseClassJavadoc(builder, AndroidClassNames.ANDROID_ENTRY_POINT);
        Processors.addGeneratedAnnotation(builder, this.env, this.getClass());
        Generators.copyLintAnnotations(this.metadata.element(), builder);
        Generators.copySuppressAnnotations(this.metadata.element(), builder);
        this.metadata.baseElement().getTypeParameters().stream().map(TypeVariableName::get).forEachOrdered(arg_0 -> ((TypeSpec.Builder)builder).addTypeVariable(arg_0));
        Generators.addInjectionMethods(this.metadata, builder);
        Generators.addComponentOverride(this.metadata, builder);
        JavaFile.builder((String)this.generatedClassName.packageName(), (TypeSpec)builder.build()).build().writeTo(this.env.getFiler());
    }

    private List<MethodSpec> baseClassConstructors() {
        return ElementFilter.constructorsIn(this.metadata.baseElement().getEnclosedElements()).stream().map(constructor -> {
            List params = constructor.getParameters().stream().map(p -> ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)p.asType()), (String)p.toString(), (Modifier[])new Modifier[0]).build()).collect(Collectors.toList());
            return MethodSpec.constructorBuilder().addParameters(params).addStatement("super($L)", new Object[]{params.stream().map(p -> p.name).collect(Collectors.joining(","))}).build();
        }).collect(Collectors.toList());
    }

    private MethodSpec onCreateMethod() throws IOException {
        return MethodSpec.methodBuilder((String)"onCreate").addAnnotation(AndroidClassNames.CALL_SUPER).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("inject()", new Object[0]).addStatement("super.onCreate()", new Object[0]).build();
    }
}

