/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import dagger.hilt.android.shaded.auto.common.MoreTypes;
import dagger.hilt.processor.internal.BadInputException;
import dagger.hilt.processor.internal.ErrorTypeException;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public final class ProcessorErrors {
    public static void checkState(boolean expression, @Nullable Object errorMessage) {
        if (!expression) {
            throw new BadInputException(String.valueOf(errorMessage));
        }
    }

    @FormatMethod
    public static void checkState(boolean expression, @Nullable @FormatString String errorMessageTemplate, Object ... errorMessageArgs) {
        if (!expression) {
            throw new BadInputException(String.format(errorMessageTemplate, errorMessageArgs));
        }
    }

    public static void checkState(boolean expression, Element badElement, @Nullable Object errorMessage) {
        Preconditions.checkNotNull((Object)badElement);
        if (!expression) {
            throw new BadInputException(String.valueOf(errorMessage), badElement);
        }
    }

    @FormatMethod
    public static void checkState(boolean expression, Element badElement, @Nullable @FormatString String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkNotNull((Object)badElement);
        if (!expression) {
            throw new BadInputException(String.format(errorMessageTemplate, errorMessageArgs), badElement);
        }
    }

    public static void checkState(boolean expression, Collection<? extends Element> badElements, @Nullable Object errorMessage) {
        Preconditions.checkNotNull(badElements);
        if (!expression) {
            Preconditions.checkState((!badElements.isEmpty() ? 1 : 0) != 0);
            throw new BadInputException(String.valueOf(errorMessage), badElements);
        }
    }

    @FormatMethod
    public static void checkState(boolean expression, Collection<? extends Element> badElements, @Nullable @FormatString String errorMessageTemplate, Object ... errorMessageArgs) {
        Preconditions.checkNotNull(badElements);
        if (!expression) {
            Preconditions.checkState((!badElements.isEmpty() ? 1 : 0) != 0);
            throw new BadInputException(String.format(errorMessageTemplate, errorMessageArgs), badElements);
        }
    }

    public static void checkNotErrorKind(TypeElement element) {
        TypeMirror currType = element.asType();
        ImmutableList.Builder typeHierarchy = ImmutableList.builder();
        while (currType.getKind() != TypeKind.NONE) {
            typeHierarchy.add((Object)currType.toString());
            if (currType.getKind() == TypeKind.ERROR) {
                throw new ErrorTypeException(String.format("%s, type hierarchy contains error kind, %s.\n\tThe partially resolved hierarchy is:\n\t\t%s", element, currType, typeHierarchy.build().stream().collect(Collectors.joining(" -> "))), element);
            }
            currType = MoreTypes.asTypeElement(currType).getSuperclass();
        }
    }

    private ProcessorErrors() {
    }
}

