/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.AggregatedElements;
import dagger.hilt.processor.internal.AnnotationValues;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.root.AutoValue_AggregatedRootMetadata;
import dagger.hilt.processor.internal.root.RootType;
import dagger.hilt.processor.internal.root.ir.AggregatedRootIr;
import dagger.internal.codegen.extension.DaggerStreams;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@AutoValue
abstract class AggregatedRootMetadata {
    AggregatedRootMetadata() {
    }

    public abstract TypeElement aggregatingElement();

    abstract TypeElement rootElement();

    abstract TypeElement originatingRootElement();

    abstract TypeElement rootAnnotation();

    abstract boolean allowsSharingComponent();

    RootType rootType() {
        return RootType.of(this.rootElement());
    }

    static ImmutableSet<AggregatedRootMetadata> from(ProcessingEnvironment env) {
        return AggregatedRootMetadata.from(AggregatedElements.from("dagger.hilt.internal.aggregatedroot.codegen", ClassNames.AGGREGATED_ROOT, env.getElementUtils()), env);
    }

    public static ImmutableSet<AggregatedRootMetadata> from(ImmutableSet<TypeElement> aggregatedElements, ProcessingEnvironment env) {
        return (ImmutableSet)aggregatedElements.stream().map(aggregatedElement -> AggregatedRootMetadata.create(aggregatedElement, env)).collect(DaggerStreams.toImmutableSet());
    }

    public static AggregatedRootIr toIr(AggregatedRootMetadata metadata) {
        return new AggregatedRootIr(ClassName.get((TypeElement)metadata.aggregatingElement()), ClassName.get((TypeElement)metadata.rootElement()), ClassName.get((TypeElement)metadata.originatingRootElement()), ClassName.get((TypeElement)metadata.rootAnnotation()), metadata.allowsSharingComponent());
    }

    private static AggregatedRootMetadata create(TypeElement element, ProcessingEnvironment env) {
        AnnotationMirror annotationMirror = Processors.getAnnotationMirror((Element)element, ClassNames.AGGREGATED_ROOT);
        ImmutableMap<String, AnnotationValue> values = Processors.getAnnotationValues(env.getElementUtils(), annotationMirror);
        TypeElement rootElement = env.getElementUtils().getTypeElement(AnnotationValues.getString((AnnotationValue)values.get((Object)"root")));
        boolean allowSharingComponent = true;
        return new AutoValue_AggregatedRootMetadata(element, rootElement, env.getElementUtils().getTypeElement(AnnotationValues.getString((AnnotationValue)values.get((Object)"originatingRoot"))), AnnotationValues.getTypeElement((AnnotationValue)values.get((Object)"rootAnnotation")), allowSharingComponent);
    }
}

