/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.shaded.auto.common.AnnotationMirrors;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Components;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aggregateddeps.AggregatedDepsGenerator;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateEntryPointGenerator;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateMetadata;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateModuleGenerator;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public final class AggregatedDepsProcessor
extends BaseProcessor {
    private static final ImmutableSet<ClassName> ENTRY_POINT_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.ENTRY_POINT, (Object)ClassNames.EARLY_ENTRY_POINT, (Object)ClassNames.GENERATED_ENTRY_POINT, (Object)ClassNames.COMPONENT_ENTRY_POINT);
    private static final ImmutableSet<ClassName> MODULE_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.MODULE);
    private static final ImmutableSet<ClassName> INSTALL_IN_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.INSTALL_IN, (Object)ClassNames.TEST_INSTALL_IN);
    private final Set<Element> seen = new HashSet<Element>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return (Set)ImmutableSet.builder().addAll(INSTALL_IN_ANNOTATIONS).addAll(MODULE_ANNOTATIONS).addAll(ENTRY_POINT_ANNOTATIONS).build().stream().map(Object::toString).collect(DaggerStreams.toImmutableSet());
    }

    @Override
    public void processEach(TypeElement annotation, Element element) throws Exception {
        if (!this.seen.add(element)) {
            return;
        }
        Optional<ClassName> installInAnnotation = AggregatedDepsProcessor.getAnnotation(element, INSTALL_IN_ANNOTATIONS);
        Optional<ClassName> entryPointAnnotation = AggregatedDepsProcessor.getAnnotation(element, ENTRY_POINT_ANNOTATIONS);
        Optional<ClassName> moduleAnnotation = AggregatedDepsProcessor.getAnnotation(element, MODULE_ANNOTATIONS);
        boolean hasInstallIn = installInAnnotation.isPresent();
        boolean isEntryPoint = entryPointAnnotation.isPresent();
        boolean isModule = moduleAnnotation.isPresent();
        ProcessorErrors.checkState(!hasInstallIn || isEntryPoint || isModule, element, "@%s-annotated classes must also be annotated with @Module or @EntryPoint: %s", installInAnnotation.map(ClassName::simpleName).orElse("@InstallIn"), element);
        ProcessorErrors.checkState(!isEntryPoint || !isModule, element, "@%s and @%s cannot be used on the same interface: %s", moduleAnnotation.map(ClassName::simpleName).orElse("@Module"), entryPointAnnotation.map(ClassName::simpleName).orElse("@EntryPoint"), element);
        if (isModule) {
            this.processModule(element, installInAnnotation, moduleAnnotation.get());
        } else if (isEntryPoint) {
            this.processEntryPoint(element, installInAnnotation, entryPointAnnotation.get());
        } else {
            throw new AssertionError();
        }
    }

    private void processModule(Element element, Optional<ClassName> installInAnnotation, ClassName moduleAnnotation) throws Exception {
        ProcessorErrors.checkState(installInAnnotation.isPresent() || AggregatedDepsProcessor.isDaggerGeneratedModule(element) || this.installInCheckDisabled(element), element, "%s is missing an @InstallIn annotation. If this was intentional, see https://dagger.dev/hilt/compiler-options#disable-install-in-check for how to disable this check.", element);
        if (!installInAnnotation.isPresent()) {
            return;
        }
        ProcessorErrors.checkState(element.getKind() == ElementKind.CLASS || element.getKind() == ElementKind.INTERFACE, element, "Only classes and interfaces can be annotated with @Module: %s", element);
        TypeElement module = MoreElements.asType(element);
        ProcessorErrors.checkState(Processors.isTopLevel(module) || module.getModifiers().contains((Object)Modifier.STATIC) || module.getModifiers().contains((Object)Modifier.ABSTRACT) || Processors.hasAnnotation(module.getEnclosingElement(), ClassNames.HILT_ANDROID_TEST), module, "Nested @%s modules must be static unless they are directly nested within a test. Found: %s", installInAnnotation.get().simpleName(), module);
        ProcessorErrors.checkState(ClassNames.APPLICATION_CONTEXT_MODULE.equals((Object)ClassName.get((TypeElement)module)) || !Processors.requiresModuleInstance(this.getElementUtils(), module) || AggregatedDepsProcessor.hasVisibleEmptyConstructor(module), module, (Object)"Modules that need to be instantiated by Hilt must have a visible, empty constructor.");
        ImmutableList abstractMethodsWithMissingBinds = (ImmutableList)ElementFilter.methodsIn(module.getEnclosedElements()).stream().filter(method -> method.getModifiers().contains((Object)Modifier.ABSTRACT)).filter(method -> !Processors.hasDaggerAbstractMethodAnnotation(method)).collect(DaggerStreams.toImmutableList());
        ProcessorErrors.checkState(abstractMethodsWithMissingBinds.isEmpty(), module, "Found unimplemented abstract methods, %s, in an abstract module, %s. Did you forget to add a Dagger binding annotation (e.g. @Binds)?", abstractMethodsWithMissingBinds, module);
        ImmutableList<TypeElement> replacedModules = ImmutableList.of();
        if (Processors.hasAnnotation((Element)module, ClassNames.TEST_INSTALL_IN)) {
            Optional<TypeElement> originatingTestElement = Processors.getOriginatingTestElement(module, this.getElementUtils());
            ProcessorErrors.checkState(!originatingTestElement.isPresent(), module, "@TestInstallIn modules cannot be nested in (or originate from) a @HiltAndroidTest-annotated class:  %s", originatingTestElement.map(testElement -> testElement.getQualifiedName().toString()).orElse(""));
            AnnotationMirror testInstallIn = Processors.getAnnotationMirror((Element)module, ClassNames.TEST_INSTALL_IN);
            replacedModules = Processors.getAnnotationClassValues(this.getElementUtils(), testInstallIn, "replaces");
            ProcessorErrors.checkState(!replacedModules.isEmpty(), module, (Object)"@TestInstallIn#replaces() cannot be empty. Use @InstallIn instead.");
            ImmutableList nonInstallInModules = (ImmutableList)replacedModules.stream().filter(replacedModule -> !Processors.hasAnnotation((Element)replacedModule, ClassNames.INSTALL_IN)).collect(DaggerStreams.toImmutableList());
            ProcessorErrors.checkState(nonInstallInModules.isEmpty(), module, "@TestInstallIn#replaces() can only contain @InstallIn modules, but found: %s", nonInstallInModules);
            ImmutableList hiltWrapperModules = (ImmutableList)replacedModules.stream().filter(replacedModule -> replacedModule.getSimpleName().toString().startsWith("HiltWrapper_")).collect(DaggerStreams.toImmutableList());
            ProcessorErrors.checkState(hiltWrapperModules.isEmpty(), module, "@TestInstallIn#replaces() cannot contain Hilt generated public wrapper modules, but found: %s. ", hiltWrapperModules);
            if (!MoreElements.getPackage(module).getQualifiedName().toString().startsWith("dagger.hilt")) {
                ImmutableList hiltInternalModules = (ImmutableList)replacedModules.stream().filter(replacedModule -> MoreElements.getPackage(replacedModule).getQualifiedName().toString().startsWith("dagger.hilt")).collect(DaggerStreams.toImmutableList());
                ProcessorErrors.checkState(hiltInternalModules.isEmpty(), module, "@TestInstallIn#replaces() cannot contain internal Hilt modules, but found: %s. ", hiltInternalModules);
            }
            ImmutableList replacedTestSpecificInstallIn = (ImmutableList)replacedModules.stream().filter(replacedModule -> Processors.getOriginatingTestElement(replacedModule, this.getElementUtils()).isPresent()).collect(DaggerStreams.toImmutableList());
            ProcessorErrors.checkState(replacedTestSpecificInstallIn.isEmpty(), module, "@TestInstallIn#replaces() cannot replace test specific @InstallIn modules, but found: %s. Please remove the @InstallIn module manually rather than replacing it.", replacedTestSpecificInstallIn);
        }
        this.generateAggregatedDeps("modules", module, moduleAnnotation, (ImmutableSet<ClassName>)((ImmutableSet)replacedModules.stream().map(ClassName::get).collect(DaggerStreams.toImmutableSet())));
    }

    private void processEntryPoint(Element element, Optional<ClassName> installInAnnotation, ClassName entryPointAnnotation) throws Exception {
        ProcessorErrors.checkState(installInAnnotation.isPresent(), element, "@%s %s must also be annotated with @InstallIn", entryPointAnnotation.simpleName(), element);
        ProcessorErrors.checkState(!Processors.hasAnnotation(element, ClassNames.TEST_INSTALL_IN), element, (Object)"@TestInstallIn can only be used with modules");
        ProcessorErrors.checkState(element.getKind() == ElementKind.INTERFACE, element, "Only interfaces can be annotated with @%s: %s", entryPointAnnotation.simpleName(), element);
        TypeElement entryPoint = MoreElements.asType(element);
        if (entryPointAnnotation.equals((Object)ClassNames.EARLY_ENTRY_POINT)) {
            ImmutableSet<ClassName> components = Components.getComponents(this.getElementUtils(), element);
            ProcessorErrors.checkState(components.equals((Object)ImmutableSet.of((Object)ClassNames.SINGLETON_COMPONENT)), element, "@EarlyEntryPoint can only be installed into the SingletonComponent. Found: %s", components);
            Optional<TypeElement> optionalTestElement = Processors.getOriginatingTestElement(element, this.getElementUtils());
            ProcessorErrors.checkState(!optionalTestElement.isPresent(), element, "@EarlyEntryPoint-annotated entry point, %s, cannot be nested in (or originate from) a @HiltAndroidTest-annotated class, %s. This requirement is to avoid confusion with other, test-specific entry points.", MoreElements.asType(element).getQualifiedName().toString(), optionalTestElement.map(testElement -> testElement.getQualifiedName().toString()).orElse(""));
        }
        this.generateAggregatedDeps(entryPointAnnotation.equals((Object)ClassNames.COMPONENT_ENTRY_POINT) ? "componentEntryPoints" : "entryPoints", entryPoint, entryPointAnnotation, (ImmutableSet<ClassName>)ImmutableSet.of());
    }

    private void generateAggregatedDeps(String key, TypeElement element, ClassName annotation, ImmutableSet<ClassName> replacedModules) throws Exception {
        ImmutableSet<ClassName> components = Components.getComponents(this.getElementUtils(), element);
        if (AggregatedDepsProcessor.isValidKind(element)) {
            Optional<PkgPrivateMetadata> pkgPrivateMetadata = PkgPrivateMetadata.of(this.getElementUtils(), element, annotation);
            if (pkgPrivateMetadata.isPresent()) {
                if (key.contentEquals("modules")) {
                    new PkgPrivateModuleGenerator(this.getProcessingEnv(), pkgPrivateMetadata.get()).generate();
                } else {
                    new PkgPrivateEntryPointGenerator(this.getProcessingEnv(), pkgPrivateMetadata.get()).generate();
                }
            } else {
                Optional<ClassName> testName = Processors.getOriginatingTestElement(element, this.getElementUtils()).map(ClassName::get);
                new AggregatedDepsGenerator(key, element, testName, components, replacedModules, this.getProcessingEnv()).generate();
            }
        }
    }

    private static Optional<ClassName> getAnnotation(Element element, ImmutableSet<ClassName> annotations) {
        ImmutableSet usedAnnotations = (ImmutableSet)annotations.stream().filter(annotation -> Processors.hasAnnotation(element, annotation)).collect(DaggerStreams.toImmutableSet());
        if (usedAnnotations.isEmpty()) {
            return Optional.empty();
        }
        ProcessorErrors.checkState(usedAnnotations.size() == 1, element, "Only one of the following annotations can be used on %s: %s", element, usedAnnotations);
        return Optional.of((ClassName)Iterables.getOnlyElement((Iterable)usedAnnotations));
    }

    private static boolean isValidKind(Element element) {
        return element.asType().getKind() != TypeKind.ERROR;
    }

    private boolean installInCheckDisabled(Element element) {
        return HiltCompilerOptions.isModuleInstallInCheckDisabled(this.getProcessingEnv()) || Processors.hasAnnotation(element, ClassNames.DISABLE_INSTALL_IN_CHECK);
    }

    private static boolean isDaggerGeneratedModule(Element element) {
        if (!Processors.hasAnnotation(element, ClassNames.MODULE)) {
            return false;
        }
        return element.getAnnotationMirrors().stream().filter(mirror -> AggregatedDepsProcessor.isGenerated(mirror)).map(mirror -> AggregatedDepsProcessor.asString((AnnotationValue)Iterables.getOnlyElement(AggregatedDepsProcessor.asList(AnnotationMirrors.getAnnotationValue(mirror, "value"))))).anyMatch(value -> value.startsWith("dagger"));
    }

    private static List<? extends AnnotationValue> asList(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor8<List<? extends AnnotationValue>, Void>(){

            @Override
            public List<? extends AnnotationValue> visitArray(List<? extends AnnotationValue> value, Void unused) {
                return value;
            }
        }, null);
    }

    private static String asString(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor8<String, Void>(){

            @Override
            public String visitString(String value, Void unused) {
                return value;
            }
        }, null);
    }

    private static boolean isGenerated(AnnotationMirror annotationMirror) {
        Name name = MoreElements.asType(annotationMirror.getAnnotationType().asElement()).getQualifiedName();
        return name.contentEquals("javax.annotation.Generated") || name.contentEquals("javax.annotation.processing.Generated");
    }

    private static boolean hasVisibleEmptyConstructor(TypeElement type) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(type.getEnclosedElements());
        return constructors.isEmpty() || constructors.stream().filter(constructor -> constructor.getParameters().isEmpty()).anyMatch(constructor -> !constructor.getModifiers().contains((Object)Modifier.PRIVATE));
    }
}

