/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotated;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XConstructorElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XEnumEntry;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableParameterElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Collection;
import java.util.Optional;
import javax.lang.model.element.ElementKind;

public final class XElements {
    public static String getSimpleName(XElement element) {
        return XConverters.toJavac(element).getSimpleName().toString();
    }

    public static XTypeElement closestEnclosingTypeElement(XElement element) {
        return XElements.optionalClosestEnclosingTypeElement(element).orElseThrow(() -> new IllegalStateException("No enclosing TypeElement for: " + element));
    }

    private static Optional<XTypeElement> optionalClosestEnclosingTypeElement(XElement element) {
        if (XElementKt.isTypeElement(element)) {
            return Optional.of(XElements.asTypeElement(element));
        }
        if (XElementKt.isConstructor(element)) {
            return Optional.of(XElements.asConstructor(element).getEnclosingElement());
        }
        if (XElementKt.isMethod(element)) {
            return XElements.optionalClosestEnclosingTypeElement(XElements.asMethod(element).getEnclosingElement());
        }
        if (XElementKt.isField(element)) {
            return XElements.optionalClosestEnclosingTypeElement(XElements.asField(element).getEnclosingElement());
        }
        if (XElementKt.isMethodParameter(element)) {
            return XElements.optionalClosestEnclosingTypeElement(XElements.asMethodParameter(element).getEnclosingMethodElement());
        }
        return Optional.empty();
    }

    public static boolean isEnumEntry(XElement element) {
        return element instanceof XEnumEntry;
    }

    public static boolean isEnum(XElement element) {
        return XConverters.toJavac(element).getKind() == ElementKind.ENUM;
    }

    public static boolean isExecutable(XElement element) {
        return XElementKt.isConstructor(element) || XElementKt.isMethod(element);
    }

    public static XExecutableElement asExecutable(XElement element) {
        Preconditions.checkState((boolean)XElements.isExecutable(element));
        return (XExecutableElement)element;
    }

    public static XTypeElement asTypeElement(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isTypeElement(element));
        return (XTypeElement)element;
    }

    public static XExecutableParameterElement asMethodParameter(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isMethodParameter(element));
        return (XExecutableParameterElement)element;
    }

    public static XFieldElement asField(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isField(element));
        return (XFieldElement)element;
    }

    public static XVariableElement asVariable(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isVariableElement(element));
        return (XVariableElement)element;
    }

    public static XConstructorElement asConstructor(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isConstructor(element));
        return (XConstructorElement)element;
    }

    public static XMethodElement asMethod(XElement element) {
        Preconditions.checkState((boolean)XElementKt.isMethod(element));
        return (XMethodElement)element;
    }

    public static ImmutableSet<XAnnotation> getAnnotatedAnnotations(XAnnotated annotated, ClassName annotationName) {
        return annotated.getAllAnnotations().stream().filter(annotation -> annotation.getType().getTypeElement().hasAnnotation(annotationName)).collect(DaggerStreams.toImmutableSet());
    }

    public static boolean hasAnyAnnotation(XAnnotated annotated, ClassName ... annotations2) {
        return XElements.hasAnyAnnotation(annotated, (Collection<ClassName>)ImmutableSet.copyOf((Object[])annotations2));
    }

    public static boolean hasAnyAnnotation(XAnnotated annotated, Collection<ClassName> annotations2) {
        return annotations2.stream().anyMatch(annotated::hasAnnotation);
    }

    public static Optional<XAnnotation> getAnyAnnotation(XAnnotated annotated, ClassName ... annotations2) {
        return XElements.getAnyAnnotation(annotated, (Collection<ClassName>)ImmutableSet.copyOf((Object[])annotations2));
    }

    public static Optional<XAnnotation> getAnyAnnotation(XAnnotated annotated, Collection<ClassName> annotations2) {
        return annotations2.stream().filter(annotated::hasAnnotation).map(annotated::getAnnotation).findFirst();
    }

    public static ImmutableSet<XAnnotation> getAllAnnotations(XAnnotated annotated, Collection<ClassName> annotations2) {
        return annotations2.stream().filter(annotated::hasAnnotation).map(annotated::getAnnotation).collect(DaggerStreams.toImmutableSet());
    }

    private XElements() {
    }
}

