/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.model;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.spi.model.AutoValue_ComponentPath;
import dagger.spi.model.DaggerTypeElement;
import java.util.stream.Collectors;

@AutoValue
public abstract class ComponentPath {
    public static ComponentPath create(Iterable<DaggerTypeElement> components) {
        return new AutoValue_ComponentPath((ImmutableList<DaggerTypeElement>)ImmutableList.copyOf(components));
    }

    public abstract ImmutableList<DaggerTypeElement> components();

    public final DaggerTypeElement rootComponent() {
        return (DaggerTypeElement)this.components().get(0);
    }

    public DaggerTypeElement currentComponent() {
        return (DaggerTypeElement)Iterables.getLast(this.components());
    }

    public final DaggerTypeElement parentComponent() {
        Preconditions.checkState((!this.atRoot() ? 1 : 0) != 0);
        return (DaggerTypeElement)this.components().reverse().get(1);
    }

    public final ComponentPath parent() {
        Preconditions.checkState((!this.atRoot() ? 1 : 0) != 0);
        return ComponentPath.create((Iterable<DaggerTypeElement>)this.components().subList(0, this.components().size() - 1));
    }

    public final ComponentPath childPath(DaggerTypeElement child) {
        return ComponentPath.create((Iterable<DaggerTypeElement>)ImmutableList.builder().addAll(this.components()).add((Object)child).build());
    }

    public final boolean atRoot() {
        return this.components().size() == 1;
    }

    public final String toString() {
        return this.components().stream().map(DaggerTypeElement::className).map(ClassName::canonicalName).collect(Collectors.joining(" \u2192 "));
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

