/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.model;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.squareup.javapoet.ClassName;
import dagger.spi.model.AutoValue_DaggerTypeElement;
import dagger.spi.model.CompilerEnvironment;
import javax.annotation.Nullable;
import javax.lang.model.element.TypeElement;

@AutoValue
public abstract class DaggerTypeElement {
    public static DaggerTypeElement fromJava(TypeElement element) {
        return new AutoValue_DaggerTypeElement(CompilerEnvironment.JAVA, (TypeElement)Preconditions.checkNotNull((Object)element), null);
    }

    public static DaggerTypeElement fromKsp(KSClassDeclaration element) {
        return new AutoValue_DaggerTypeElement(CompilerEnvironment.KSP, null, (KSClassDeclaration)Preconditions.checkNotNull((Object)element));
    }

    public TypeElement java() {
        Preconditions.checkState((this.compiler() == CompilerEnvironment.JAVA ? 1 : 0) != 0);
        return this.javaInternal();
    }

    public KSClassDeclaration ksp() {
        Preconditions.checkState((this.compiler() == CompilerEnvironment.KSP ? 1 : 0) != 0);
        return this.kspInternal();
    }

    public ClassName className() {
        if (this.compiler() == CompilerEnvironment.KSP) {
            throw new UnsupportedOperationException("Method className() is not yet supported in KSP.");
        }
        return ClassName.get((TypeElement)this.java());
    }

    public abstract CompilerEnvironment compiler();

    @Nullable
    abstract TypeElement javaInternal();

    @Nullable
    abstract KSClassDeclaration kspInternal();

    public final String toString() {
        return (this.compiler() == CompilerEnvironment.JAVA ? this.java() : this.ksp()).toString();
    }
}

