/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import dagger.internal.codegen.Util;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.ElementFilter;

final class SimpleAnnotationMirror
implements AnnotationMirror {
    private final TypeElement annotationType;
    private final ImmutableMap<String, ? extends AnnotationValue> namedValues;
    private final ImmutableMap<ExecutableElement, ? extends AnnotationValue> elementValues;

    private SimpleAnnotationMirror(TypeElement annotationType, Map<String, ? extends AnnotationValue> namedValues) {
        Preconditions.checkArgument((boolean)annotationType.getKind().equals((Object)ElementKind.ANNOTATION_TYPE), (String)"annotationType must be an annotation: %s", (Object)annotationType);
        Preconditions.checkArgument((boolean)FluentIterable.from(ElementFilter.methodsIn(annotationType.getEnclosedElements())).transform(Util.ELEMENT_SIMPLE_NAME).toSet().equals(namedValues.keySet()), (String)"namedValues must have values for exactly the members in %s: %s", (Object)annotationType, namedValues);
        this.annotationType = annotationType;
        this.namedValues = ImmutableMap.copyOf(namedValues);
        this.elementValues = Maps.toMap(ElementFilter.methodsIn(annotationType.getEnclosedElements()), (Function)Functions.compose((Function)Functions.forMap(namedValues), Util.ELEMENT_SIMPLE_NAME));
    }

    @Override
    public DeclaredType getAnnotationType() {
        return MoreTypes.asDeclared(this.annotationType.asType());
    }

    public Map<ExecutableElement, ? extends AnnotationValue> getElementValues() {
        return this.elementValues;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("@").append(this.annotationType.getQualifiedName());
        if (!this.namedValues.isEmpty()) {
            builder.append('(').append(Joiner.on((String)", ").withKeyValueSeparator(" = ").join(this.namedValues)).append(')');
        }
        return builder.toString();
    }

    static AnnotationMirror of(TypeElement annotationType) {
        return SimpleAnnotationMirror.of(annotationType, (Map<String, ? extends AnnotationValue>)ImmutableMap.of());
    }

    static AnnotationMirror of(TypeElement annotationType, Map<String, ? extends AnnotationValue> namedValues) {
        return new SimpleAnnotationMirror(annotationType, namedValues);
    }
}

