/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import dagger.internal.codegen.Accessibility;
import dagger.internal.codegen.CodeBlocks;
import dagger.internal.codegen.TypeNames;
import dagger.internal.codegen.UniqueNameSet;
import dagger.shaded.auto.common.MoreElements;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

final class Proxies {
    static boolean shouldGenerateProxy(ExecutableElement method) {
        return !Accessibility.isElementPubliclyAccessible(method) || method.getParameters().stream().map(Element::asType).anyMatch(type -> !Accessibility.isRawTypePubliclyAccessible(type));
    }

    static boolean requiresProxyAccess(ExecutableElement method, String callingPackage) {
        return !Accessibility.isElementAccessibleFrom((Element)method, callingPackage) || method.getParameters().stream().map(Element::asType).anyMatch(type -> !Accessibility.isRawTypeAccessible(type, callingPackage));
    }

    static String proxyName(ExecutableElement method) {
        switch (method.getKind()) {
            case CONSTRUCTOR: {
                return "new" + method.getEnclosingElement().getSimpleName();
            }
            case METHOD: {
                return "proxy" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, method.getSimpleName().toString());
            }
            case STATIC_INIT: 
            case INSTANCE_INIT: {
                throw new IllegalArgumentException("cannot proxy initializers because they cannot be invoked directly: " + method);
            }
        }
        throw new AssertionError(method);
    }

    static MethodSpec createProxy(ExecutableElement method) {
        MethodSpec.Builder builder;
        Preconditions.checkArgument((boolean)Proxies.shouldGenerateProxy(method), (String)"method and all of its arguments are accessible; proxy isn't necessary: %s", (Object)method);
        switch (method.getKind()) {
            case CONSTRUCTOR: {
                builder = Proxies.forConstructor(method);
                break;
            }
            case METHOD: {
                builder = Proxies.forMethod(method);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        builder.addJavadoc("Proxies $L.", CodeBlocks.javadocLinkTo(method));
        builder.addModifiers(Modifier.PUBLIC, Modifier.STATIC);
        Proxies.copyTypeParameters(method, builder);
        Proxies.copyThrows(method, builder);
        return builder.build();
    }

    private static MethodSpec.Builder forConstructor(ExecutableElement constructor) {
        TypeElement enclosingType = MoreElements.asType(constructor.getEnclosingElement());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder(Proxies.proxyName(constructor));
        Proxies.copyTypeParameters(enclosingType, methodBuilder);
        methodBuilder.returns(TypeName.get(enclosingType.asType()));
        CodeBlock arguments = Proxies.copyParameters(constructor, methodBuilder, new UniqueNameSet(), (ImmutableList.Builder<CodeBlock>)new ImmutableList.Builder());
        methodBuilder.addCode("return new $T($L);", enclosingType, arguments);
        return methodBuilder;
    }

    private static MethodSpec.Builder forMethod(ExecutableElement method) {
        TypeElement enclosingType = MoreElements.asType(method.getEnclosingElement());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder(Proxies.proxyName(method));
        UniqueNameSet nameSet = new UniqueNameSet();
        ImmutableList.Builder argumentsBuilder = new ImmutableList.Builder();
        if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
            methodBuilder.addParameter(TypeName.get(enclosingType.asType()), nameSet.getUniqueName("instance"), new Modifier[0]);
        }
        CodeBlock arguments = Proxies.copyParameters(method, methodBuilder, nameSet, (ImmutableList.Builder<CodeBlock>)argumentsBuilder);
        if (!method.getReturnType().getKind().equals((Object)TypeKind.VOID)) {
            methodBuilder.addCode("return ", new Object[0]);
        }
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            methodBuilder.addCode("$T", TypeNames.rawTypeName(TypeName.get(enclosingType.asType())));
        } else {
            Proxies.copyTypeParameters(enclosingType, methodBuilder);
            methodBuilder.addCode("instance", method.getSimpleName());
        }
        methodBuilder.addCode(".$N($L);", method.getSimpleName(), arguments);
        methodBuilder.returns(TypeName.get(method.getReturnType()));
        return methodBuilder;
    }

    private static void copyThrows(ExecutableElement method, MethodSpec.Builder methodBuilder) {
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            methodBuilder.addException(TypeName.get(typeMirror));
        }
    }

    private static CodeBlock copyParameters(ExecutableElement method, MethodSpec.Builder methodBuilder, UniqueNameSet nameSet, ImmutableList.Builder<CodeBlock> argumentsBuilder) {
        for (VariableElement variableElement : method.getParameters()) {
            TypeMirror parameterType = variableElement.asType();
            boolean useObject = !Accessibility.isTypePubliclyAccessible(parameterType);
            TypeName typeName = useObject ? TypeName.OBJECT : TypeName.get(parameterType);
            String name = nameSet.getUniqueName(variableElement.getSimpleName().toString());
            argumentsBuilder.add((Object)(useObject ? CodeBlock.of("($T) $L", parameterType, name) : CodeBlock.of(name, new Object[0])));
            ParameterSpec.Builder parameterBuilder = ParameterSpec.builder(typeName, name, new Modifier[0]).addModifiers((Modifier[])Iterables.toArray(variableElement.getModifiers(), Modifier.class));
            methodBuilder.addParameter(parameterBuilder.build());
        }
        methodBuilder.varargs(method.isVarArgs());
        return CodeBlocks.makeParametersCodeBlock((Iterable<CodeBlock>)argumentsBuilder.build());
    }

    private static void copyTypeParameters(Parameterizable parameterizable, MethodSpec.Builder methodBuilder) {
        for (TypeParameterElement typeParameterElement : parameterizable.getTypeParameters()) {
            methodBuilder.addTypeVariable(TypeVariableName.get(typeParameterElement));
        }
    }

    private Proxies() {
    }
}

