/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import dagger.internal.codegen.AutoValue_MapType;
import dagger.internal.codegen.FrameworkTypes;
import dagger.internal.codegen.Key;
import dagger.shaded.auto.common.MoreTypes;
import java.util.Map;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

abstract class MapType {
    MapType() {
    }

    protected abstract Equivalence.Wrapper<DeclaredType> wrappedDeclaredMapType();

    DeclaredType declaredMapType() {
        return (DeclaredType)this.wrappedDeclaredMapType().get();
    }

    boolean isRawType() {
        return this.declaredMapType().getTypeArguments().isEmpty();
    }

    TypeMirror keyType() {
        Preconditions.checkState((!this.isRawType() ? 1 : 0) != 0);
        return this.declaredMapType().getTypeArguments().get(0);
    }

    TypeMirror valueType() {
        Preconditions.checkState((!this.isRawType() ? 1 : 0) != 0);
        return this.declaredMapType().getTypeArguments().get(1);
    }

    boolean valuesAreTypeOf(Class<?> clazz) {
        return MoreTypes.isType(this.valueType()) && MoreTypes.isTypeOf(clazz, this.valueType());
    }

    boolean valuesAreFrameworkType() {
        return FrameworkTypes.isFrameworkType(this.valueType());
    }

    TypeMirror unwrappedValueType(Class<?> wrappingClass) {
        Preconditions.checkArgument((wrappingClass.getTypeParameters().length == 1 ? 1 : 0) != 0, (String)"%s must have exactly one type parameter", wrappingClass);
        Preconditions.checkState((boolean)this.valuesAreTypeOf(wrappingClass), (String)"expected values to be %s: %s", wrappingClass, (Object)this);
        return MoreTypes.asDeclared(this.valueType()).getTypeArguments().get(0);
    }

    static boolean isMap(TypeMirror type) {
        return MoreTypes.isType(type) && MoreTypes.isTypeOf(Map.class, type);
    }

    static boolean isMap(Key key) {
        return MapType.isMap(key.type());
    }

    static MapType from(TypeMirror type) {
        Preconditions.checkArgument((boolean)MapType.isMap(type), (String)"%s is not a Map", (Object)type);
        return new AutoValue_MapType((Equivalence.Wrapper<DeclaredType>)MoreTypes.equivalence().wrap((Object)MoreTypes.asDeclared(type)));
    }

    static MapType from(Key key) {
        return MapType.from(key.type());
    }
}

