/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.internal.shaded.androidx.room3.compiler.processing.ksp;

import com.google.devtools.ksp.UtilsKt;
import com.google.devtools.ksp.symbol.KSAnnotated;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import com.google.devtools.ksp.symbol.KSFunctionDeclaration;
import com.google.devtools.ksp.symbol.KSNode;
import com.google.devtools.ksp.symbol.KSPropertyDeclaration;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XEquality;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.ksp.KspProcessingEnv;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b \u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u000eH\u0016J\b\u0010 \u001a\u00020\u0017H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR%\u0010\u000f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00110\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u001c\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0015\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006!"}, d2={"Ldagger/spi/internal/shaded/androidx/room3/compiler/processing/ksp/KspElement;", "Ldagger/spi/internal/shaded/androidx/room3/compiler/processing/XElement;", "Ldagger/spi/internal/shaded/androidx/room3/compiler/processing/XEquality;", "env", "Ldagger/spi/internal/shaded/androidx/room3/compiler/processing/ksp/KspProcessingEnv;", "declaration", "Lcom/google/devtools/ksp/symbol/KSAnnotated;", "<init>", "(Landroidx/room3/compiler/processing/ksp/KspProcessingEnv;Lcom/google/devtools/ksp/symbol/KSAnnotated;)V", "getEnv$room3_compiler_processing", "()Landroidx/room3/compiler/processing/ksp/KspProcessingEnv;", "getDeclaration", "()Lcom/google/devtools/ksp/symbol/KSAnnotated;", "kindName", "", "equalityItems", "", "", "getEqualityItems", "()[Ljava/lang/Object;", "equalityItems$delegate", "Lkotlin/Lazy;", "equals", "", "other", "hashCode", "", "toString", "docComment", "getDocComment", "()Ljava/lang/String;", "docComment$delegate", "validate", "room3-compiler-processing"})
public abstract class KspElement
implements XElement,
XEquality {
    @NotNull
    private final KspProcessingEnv env;
    @NotNull
    private final KSAnnotated declaration;
    @NotNull
    private final Lazy equalityItems$delegate;
    @NotNull
    private final Lazy docComment$delegate;

    public KspElement(@NotNull KspProcessingEnv env, @NotNull KSAnnotated declaration) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.env = env;
        this.declaration = declaration;
        this.equalityItems$delegate = LazyKt.lazy(() -> KspElement.equalityItems_delegate$lambda$0(this));
        this.docComment$delegate = LazyKt.lazy(() -> KspElement.docComment_delegate$lambda$0(this));
    }

    @NotNull
    public final KspProcessingEnv getEnv$room3_compiler_processing() {
        return this.env;
    }

    @NotNull
    public KSAnnotated getDeclaration() {
        return this.declaration;
    }

    @Override
    @NotNull
    public String kindName() {
        String string;
        KSAnnotated kSAnnotated = this.getDeclaration();
        if (kSAnnotated instanceof KSClassDeclaration) {
            KSAnnotated kSAnnotated2 = this.getDeclaration();
            Intrinsics.checkNotNull((Object)kSAnnotated2, (String)"null cannot be cast to non-null type com.google.devtools.ksp.symbol.KSClassDeclaration");
            String string2 = ((KSClassDeclaration)kSAnnotated2).getClassKind().name();
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            String string3 = string2.toLowerCase(locale);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else if (kSAnnotated instanceof KSPropertyDeclaration) {
            string = "property";
        } else if (kSAnnotated instanceof KSFunctionDeclaration) {
            string = "function";
        } else {
            string = Reflection.getOrCreateKotlinClass(this.getDeclaration().getClass()).getSimpleName();
            if (string == null) {
                string = "unknown";
            }
        }
        return string;
    }

    @Override
    @NotNull
    public final Object[] getEqualityItems() {
        Lazy lazy = this.equalityItems$delegate;
        return (Object[])lazy.getValue();
    }

    public boolean equals(@Nullable Object other) {
        return XEquality.Companion.equals(this, other);
    }

    public int hashCode() {
        return XEquality.Companion.hashCode(this.getEqualityItems());
    }

    @NotNull
    public String toString() {
        return this.getDeclaration().toString();
    }

    @Override
    @Nullable
    public String getDocComment() {
        Lazy lazy = this.docComment$delegate;
        return (String)lazy.getValue();
    }

    @Override
    public boolean validate() {
        return UtilsKt.validate$default((KSNode)((KSNode)this.getDeclaration()), null, (int)1, null);
    }

    private static final KSAnnotated[] equalityItems_delegate$lambda$0(KspElement this$0) {
        KSAnnotated[] kSAnnotatedArray = new KSAnnotated[]{this$0.getDeclaration()};
        return kSAnnotatedArray;
    }

    private static final String docComment_delegate$lambda$0(KspElement this$0) {
        KSAnnotated kSAnnotated = this$0.getDeclaration();
        KSDeclaration kSDeclaration = kSAnnotated instanceof KSDeclaration ? (KSDeclaration)kSAnnotated : null;
        return kSDeclaration != null ? kSDeclaration.getDocString() : null;
    }
}

