/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XHasModifiers;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeParameterElement;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.streams.jdk8.StreamsKt;

public final class XTypeElements {
    public static ImmutableList<XTypeName> typeVariableNames(XTypeElement typeElement) {
        return (ImmutableList)typeElement.getTypeParameters().stream().map(XTypeParameterElement::asTypeVariableName).collect(DaggerStreams.toImmutableList());
    }

    public static boolean isNested(XTypeElement typeElement) {
        return typeElement.getEnclosingTypeElement() != null;
    }

    public static boolean hasTypeParameters(XTypeElement typeElement) {
        return !typeElement.getTypeParameters().isEmpty();
    }

    public static ImmutableList<XMethodElement> getAllUnimplementedMethods(XTypeElement type) {
        return (ImmutableList)XTypeElements.getAllNonPrivateInstanceMethods(type).stream().filter(XHasModifiers::isAbstract).collect(DaggerStreams.toImmutableList());
    }

    public static ImmutableList<XMethodElement> getAllNonPrivateInstanceMethods(XTypeElement type) {
        return (ImmutableList)XTypeElements.getAllMethods(type).stream().filter(method -> !method.isPrivate() && !method.isStatic()).collect(DaggerStreams.toImmutableList());
    }

    public static ImmutableList<XMethodElement> getAllMethods(XTypeElement type) {
        return (ImmutableList)StreamsKt.asStream(type.getAllMethods()).filter(method -> XTypeElements.isAccessibleFrom(method, type)).collect(DaggerStreams.toImmutableList());
    }

    public static ImmutableList<XMethodElement> getAllMethodsIncludingPrivate(XTypeElement type) {
        return (ImmutableList)StreamsKt.asStream(type.getAllMethods()).collect(DaggerStreams.toImmutableList());
    }

    private static boolean isAccessibleFrom(XMethodElement method, XTypeElement type) {
        if (method.isPublic() || method.isProtected()) {
            return true;
        }
        if (method.isPrivate()) {
            return false;
        }
        return method.getClosestMemberContainer().getClassName().packageName().equals(type.getClassName().packageName());
    }

    public static boolean isEffectivelyPublic(XTypeElement element) {
        return XTypeElements.allVisibilities(element).stream().allMatch(visibility -> visibility.equals((Object)Visibility.PUBLIC));
    }

    public static boolean isEffectivelyPrivate(XTypeElement element) {
        return XTypeElements.allVisibilities(element).contains((Object)Visibility.PRIVATE);
    }

    public static boolean isJvmClass(XTypeElement element) {
        return element.isClass() || element.isKotlinObject() || element.isCompanionObject();
    }

    private static ImmutableSet<Visibility> allVisibilities(XTypeElement element) {
        Preconditions.checkNotNull((Object)element);
        ImmutableSet.Builder visibilities = ImmutableSet.builder();
        for (XTypeElement currentElement = element; currentElement != null; currentElement = currentElement.getEnclosingTypeElement()) {
            visibilities.add((Object)Visibility.of(currentElement));
        }
        return visibilities.build();
    }

    public static String toStableString(XTypeElement typeElement) {
        try {
            return XTypeElements.toStableString(typeElement.getType().getTypeName(), new HashSet<TypeName>(), 0);
        }
        catch (TypeNotPresentException e) {
            return e.typeName();
        }
    }

    private static String toStableString(TypeName typeName, Set<TypeName> visited, int depth) {
        if (typeName instanceof ClassName) {
            return ((ClassName)typeName).canonicalName();
        }
        if (typeName instanceof ArrayTypeName) {
            return String.format("%s[]", XTypeElements.toStableString(((ArrayTypeName)typeName).componentType, visited, depth + 1));
        }
        if (typeName instanceof ParameterizedTypeName) {
            ParameterizedTypeName parameterizedTypeName = (ParameterizedTypeName)typeName;
            return String.format("%s<%s>", parameterizedTypeName.rawType, parameterizedTypeName.typeArguments.stream().map(typeArgument -> XTypeElements.toStableString(typeArgument, visited, depth + 1)).collect(Collectors.joining(",")));
        }
        if (typeName instanceof WildcardTypeName) {
            WildcardTypeName wildcardTypeName = (WildcardTypeName)typeName;
            TypeName upperBound = (TypeName)Iterables.getOnlyElement((Iterable)wildcardTypeName.upperBounds);
            if (!upperBound.equals((Object)TypeName.OBJECT)) {
                Preconditions.checkState((boolean)wildcardTypeName.lowerBounds.isEmpty());
                return String.format("? extends %s", XTypeElements.toStableString(upperBound, visited, depth + 1));
            }
            if (!wildcardTypeName.lowerBounds.isEmpty()) {
                TypeName lowerBound = (TypeName)Iterables.getOnlyElement((Iterable)wildcardTypeName.lowerBounds);
                return String.format("? super %s", XTypeElements.toStableString(lowerBound, visited, depth + 1));
            }
            return "?";
        }
        if (typeName instanceof TypeVariableName) {
            TypeVariableName typeVariableName = (TypeVariableName)typeName;
            return typeVariableName.bounds.isEmpty() || depth != 1 ? typeVariableName.name : String.format("%s extends %s", typeVariableName.name, typeVariableName.bounds.stream().map(bound -> XTypeElements.toStableString(bound, visited, depth + 1)).collect(Collectors.joining(" & ")));
        }
        return typeName.toString();
    }

    private XTypeElements() {
    }

    private static enum Visibility {
        PUBLIC,
        PRIVATE,
        OTHER;


        private static Visibility of(XTypeElement element) {
            Preconditions.checkNotNull((Object)element);
            if (element.isPrivate()) {
                return PRIVATE;
            }
            if (element.isPublic()) {
                return PUBLIC;
            }
            return OTHER;
        }
    }
}

