/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.TypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XMethodElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.compat.XConverters;
import java.util.Optional;
import javax.lang.model.SourceVersion;
import javax.lang.model.type.TypeKind;

public final class XProcessingEnvs {
    public static boolean isPreJava8SourceVersion(XProcessingEnv processingEnv) {
        Optional<SourceVersion> javaSourceVersion = XProcessingEnvs.javaSourceVersion(processingEnv);
        return javaSourceVersion.isPresent() && javaSourceVersion.get().compareTo(SourceVersion.RELEASE_8) < 0;
    }

    private static Optional<SourceVersion> javaSourceVersion(XProcessingEnv processingEnv) {
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return Optional.of(XConverters.toJavac(processingEnv).getSourceVersion());
            }
            case KSP: {
                return Optional.empty();
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)processingEnv.getBackend())));
    }

    public static boolean javacOverrides(XMethodElement overrider, XMethodElement overridden, XTypeElement type) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv(type);
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XConverters.toJavac(processingEnv).getElementUtils().overrides(XConverters.toJavac(overrider), XConverters.toJavac(overridden), XConverters.toJavac(type));
            }
            case KSP: {
                return overrider.overrides(overridden, type);
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)processingEnv.getBackend())));
    }

    public static XType getUnboundedWildcardType(XProcessingEnv processingEnv) {
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XConverters.toXProcessing(XConverters.toJavac(processingEnv).getTypeUtils().getWildcardType(null, null), processingEnv);
            }
            case KSP: {
                return XConverters.toXProcessing(XConverters.toKS(processingEnv.requireType("java.util.List")).starProjection(), processingEnv).getTypeArguments().get(0);
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)processingEnv.getBackend())));
    }

    public static XType unwrapType(XType type) {
        XType unwrapped = XProcessingEnvs.unwrapTypeOrDefault(type, null);
        Preconditions.checkArgument((unwrapped != null ? 1 : 0) != 0, (String)"%s is a raw type", (Object)type);
        return unwrapped;
    }

    public static XType unwrapTypeOrObject(XType type, XProcessingEnv processingEnv) {
        return XProcessingEnvs.unwrapTypeOrDefault(type, processingEnv.requireType((TypeName)TypeName.OBJECT));
    }

    private static XType unwrapTypeOrDefault(XType type, XType defaultType) {
        XTypeElement typeElement = type.getTypeElement();
        Preconditions.checkArgument((!typeElement.getType().getTypeArguments().isEmpty() ? 1 : 0) != 0, (String)"%s does not have a type parameter", (Object)typeElement.getQualifiedName());
        return (XType)Iterables.getOnlyElement(type.getTypeArguments(), (Object)defaultType);
    }

    public static XType getPrimitiveIntType(XProcessingEnv processingEnv) {
        return XConverters.toXProcessing(XConverters.toJavac(processingEnv).getTypeUtils().getPrimitiveType(TypeKind.INT), processingEnv);
    }

    public static XType wrapType(XClassName wrapper, XType type, XProcessingEnv processingEnv) {
        return processingEnv.getDeclaredType(processingEnv.requireTypeElement(wrapper), type);
    }

    private XProcessingEnvs() {
    }
}

