/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.kotlinpoet.KModifier;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.xprocessing.Nullability;
import dagger.internal.codegen.xprocessing.NullableTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XAnnotationSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XParameterSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XPropertySpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.compat.XConverters;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XExecutableParameterElement;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Modifier;

public final class XParameterSpecs {
    public static XParameterSpec from(XPropertySpec property) {
        XParameterSpec.Builder builder = XParameterSpecs.of(property.getName(), property.getType()).toBuilder();
        XConverters.toJavaPoet((XParameterSpec.Builder)builder).annotations.addAll(XConverters.toJavaPoet((XPropertySpec)property).annotations);
        XConverters.toKotlinPoet(builder).addAnnotations((Iterable)XConverters.toKotlinPoet(property).getAnnotations());
        return builder.build();
    }

    public static XParameterSpec from(XExecutableParameterElement parameter) {
        return XParameterSpecs.builder(parameter.getJvmName(), parameter.getType().asTypeName()).build();
    }

    public static XParameterSpec from(XExecutableParameterElement parameter, XType parameterType, CompilerOptions compilerOptions) {
        return XParameterSpecs.of(parameter.getJvmName(), parameterType, Nullability.of(parameter), compilerOptions);
    }

    @Deprecated
    public static XParameterSpec of(String name, XTypeName typeName, Nullability nullability, CompilerOptions compilerOptions) {
        return XParameterSpecs.builder(name, typeName, nullability, compilerOptions).build();
    }

    public static XParameterSpec of(String name, XType type, Nullability nullability, CompilerOptions compilerOptions) {
        return XParameterSpecs.builder(name, type, nullability, compilerOptions).build();
    }

    public static XParameterSpec of(String name, XTypeName typeName) {
        return XParameterSpecs.builder(name, typeName).build();
    }

    @Deprecated
    public static Builder builder(String name, XTypeName typeName, Nullability nullability, CompilerOptions compilerOptions) {
        return new Builder(name, NullableTypeNames.asNullableTypeName(typeName, nullability, compilerOptions)).addAnnotationNames((Collection<XClassName>)nullability.nonTypeUseNullableAnnotations());
    }

    public static Builder builder(String name, XType type, Nullability nullability, CompilerOptions compilerOptions) {
        return XParameterSpecs.builder(name, NullableTypeNames.asNullableTypeName(type, compilerOptions)).addAnnotationNames((Collection<XClassName>)nullability.nonTypeUseNullableAnnotations());
    }

    public static Builder builder(String name, XTypeName typeName) {
        return new Builder(name, typeName);
    }

    private XParameterSpecs() {
    }

    public static class Builder {
        private final String name;
        private final XTypeName typeName;
        private Boolean isFinal = null;
        private final List<XAnnotationSpec> annotations = new ArrayList<XAnnotationSpec>();

        Builder(String name, XTypeName typeName) {
            this.name = name;
            this.typeName = typeName;
        }

        @CanIgnoreReturnValue
        public Builder addModifiers(Collection<Modifier> modifiers) {
            return this.addModifiers(modifiers.toArray(new Modifier[0]));
        }

        @CanIgnoreReturnValue
        public Builder addModifiers(Modifier ... modifiers) {
            block3: for (Modifier modifier : modifiers) {
                switch (modifier) {
                    case FINAL: {
                        this.isFinal = true;
                        continue block3;
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected modifier: " + (Object)((Object)modifier)));
                    }
                }
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotations(Collection<XAnnotationSpec> annotations) {
            annotations.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotationNames(Collection<XClassName> annotationNames) {
            annotationNames.forEach(this::addAnnotation);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XClassName annotationName) {
            return this.addAnnotation(XAnnotationSpec.of(annotationName));
        }

        @CanIgnoreReturnValue
        public Builder addAnnotation(XAnnotationSpec annotation) {
            this.annotations.add(annotation);
            return this;
        }

        public XParameterSpec build() {
            XParameterSpec.Builder builder = XParameterSpec.builder(this.name, this.typeName, false);
            if (this.isFinal == null) {
                XConverters.toJavaPoet((XParameterSpec.Builder)builder).modifiers.remove((Object)Modifier.FINAL);
            } else if (!this.isFinal.booleanValue()) {
                XConverters.toJavaPoet((XParameterSpec.Builder)builder).modifiers.remove((Object)Modifier.FINAL);
                XConverters.toKotlinPoet(builder).getModifiers().remove(KModifier.FINAL);
            }
            return builder.addAnnotations(this.annotations).build();
        }
    }
}

