/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.squareup.javapoet.TypeName;
import dagger.internal.codegen.xprocessing.XProcessingEnvs;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XRawType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.compat.XConverters;
import java.util.Optional;

public final class XExpressionType {
    private final Optional<XType> optionalType;
    private final Optional<XRawType> optionalRawType;
    private final XProcessingEnv processingEnv;

    public static XExpressionType create(XType type) {
        return new XExpressionType(Optional.of(type), Optional.empty(), XConverters.getProcessingEnv(type));
    }

    static XExpressionType create(XRawType type, XProcessingEnv processingEnv) {
        return new XExpressionType(Optional.empty(), Optional.of(type), processingEnv);
    }

    public static XExpressionType createRawType(XType type) {
        return XExpressionType.create(type.getRawType(), XConverters.getProcessingEnv(type));
    }

    private XExpressionType(Optional<XType> optionalType, Optional<XRawType> optionalRawType, XProcessingEnv processingEnv) {
        this.optionalType = optionalType;
        this.optionalRawType = optionalRawType;
        this.processingEnv = processingEnv;
        Preconditions.checkState((optionalType.isPresent() || optionalRawType.isPresent() ? 1 : 0) != 0);
    }

    public XExpressionType unwrapType() {
        return this.optionalType.isPresent() && !XTypes.isRawParameterizedType(this.optionalType.get()) ? XExpressionType.create(XProcessingEnvs.unwrapType(this.optionalType.get())) : XExpressionType.create(this.processingEnv.requireType((TypeName)TypeName.OBJECT));
    }

    public XExpressionType wrapType(XClassName wrapper) {
        return this.optionalType.isPresent() ? XExpressionType.create(XProcessingEnvs.wrapType(wrapper, this.optionalType.get(), this.processingEnv)) : XExpressionType.createRawType(this.processingEnv.requireType(wrapper));
    }

    public XExpressionType rewrapType(XClassName wrapper) {
        return this.optionalType.isPresent() ? XExpressionType.create(XTypes.rewrapType(this.optionalType.get(), wrapper)) : XExpressionType.createRawType(this.processingEnv.requireType(wrapper));
    }

    public TypeName getTypeName() {
        return this.optionalType.isPresent() ? this.optionalType.get().getTypeName() : this.optionalRawType.get().getTypeName();
    }

    public XTypeName asTypeName() {
        return this.optionalType.isPresent() ? this.optionalType.get().asTypeName() : this.optionalRawType.get().asTypeName();
    }

    public boolean isSameType(XType type) {
        return this.optionalType.isPresent() ? this.optionalType.get().isSameType(type) : XTypes.isRawParameterizedType(type) && this.getTypeName().equals((Object)type.getTypeName());
    }

    public boolean isSameType(XRawType type) {
        return this.getTypeName().equals((Object)type.getTypeName());
    }

    public boolean isAssignableTo(XType type) {
        return this.optionalType.isPresent() ? type.isAssignableFrom(this.optionalType.get()) : type.getRawType().isAssignableFrom(this.optionalRawType.get());
    }

    public boolean isAssignableTo(XRawType rawType2) {
        return this.optionalType.isPresent() ? rawType2.isAssignableFrom(this.optionalType.get()) : rawType2.isAssignableFrom(this.optionalRawType.get());
    }

    Optional<XType> asType() {
        return this.optionalType;
    }

    Optional<XRawType> asRawType() {
        return this.optionalRawType;
    }

    XProcessingEnv getProcessingEnv() {
        return this.processingEnv;
    }
}

