/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.squareup.javapoet.CodeBlock;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XExpressionType;
import dagger.internal.codegen.xprocessing.XTypes;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XRawType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;

public final class XExpression {
    private final XExpressionType type;
    private final XCodeBlock codeBlock;

    private XExpression(XExpressionType type, XCodeBlock codeBlock) {
        this.type = type;
        this.codeBlock = codeBlock;
    }

    public static XExpression create(XType type, CodeBlock expression) {
        return XExpression.create(type, XCodeBlocks.toXPoet(expression));
    }

    public static XExpression create(XType type, XCodeBlock expression) {
        return new XExpression(XExpressionType.create(type), expression);
    }

    public static XExpression create(XExpressionType type, CodeBlock expression) {
        return XExpression.create(type, XCodeBlocks.toXPoet(expression));
    }

    public static XExpression create(XExpressionType type, XCodeBlock expression) {
        return new XExpression(type, expression);
    }

    public XExpression castTo(XType newType) {
        return XExpression.create(newType, XCodeBlock.ofCast(newType.asTypeName(), this.codeBlock));
    }

    public XExpression castTo(XRawType newRawType) {
        return XExpression.create(XExpressionType.create(newRawType, this.type.getProcessingEnv()), XCodeBlock.ofCast(newRawType.asTypeName(), this.codeBlock));
    }

    public XExpression box() {
        return this.type.asType().isPresent() && XTypes.isPrimitive(this.type.asType().get()) ? this.castTo(this.type.asType().get().boxed()) : this;
    }

    public XExpressionType type() {
        return this.type;
    }

    public XCodeBlock codeBlock() {
        return this.codeBlock;
    }

    public String toString() {
        return String.format("[%s] %s", this.type.getTypeName(), this.codeBlock);
    }
}

