/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.base.ContributionType;
import dagger.internal.codegen.base.SetType;
import dagger.internal.codegen.binding.BindingGraph;
import dagger.internal.codegen.binding.BindingRequest;
import dagger.internal.codegen.binding.KeyVariableNamer;
import dagger.internal.codegen.binding.MultiboundSetBinding;
import dagger.internal.codegen.compileroption.CompilerOptions;
import dagger.internal.codegen.model.DependencyRequest;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.DelegateRequestRepresentation;
import dagger.internal.codegen.writing.DerivedFromFrameworkInstanceRequestRepresentation;
import dagger.internal.codegen.writing.RequestRepresentation;
import dagger.internal.codegen.xprocessing.Accessibility;
import dagger.internal.codegen.xprocessing.XCodeBlocks;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.internal.codegen.xprocessing.XExpression;
import dagger.internal.codegen.xprocessing.XFunSpecs;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XFunSpec;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XTypeName;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import java.util.Collection;
import javax.lang.model.element.Modifier;

final class SetRequestRepresentation
extends RequestRepresentation {
    private final MultiboundSetBinding binding;
    private final BindingGraph graph;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final CompilerOptions compilerOptions;
    private final XProcessingEnv processingEnv;
    private final ComponentImplementation.ShardImplementation shard;

    @AssistedInject
    SetRequestRepresentation(@Assisted MultiboundSetBinding binding, BindingGraph graph, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations, CompilerOptions compilerOptions, XProcessingEnv processingEnv) {
        this.binding = binding;
        this.graph = graph;
        this.shard = componentImplementation.shardImplementation(binding);
        this.componentRequestRepresentations = componentRequestRepresentations;
        this.compilerOptions = compilerOptions;
        this.processingEnv = processingEnv;
    }

    @Override
    XExpression getDependencyExpression(XClassName requestingClass) {
        boolean isImmutableSetAvailable = this.isImmutableSetAvailable();
        if (isImmutableSetAvailable && this.binding.dependencies().stream().allMatch(this::isSingleValue)) {
            return XExpression.create(this.immutableSetType(), XCodeBlock.builder().add("%T.", XTypeNames.IMMUTABLE_SET).add(this.maybeTypeParameter(requestingClass)).add("of(%L)", this.binding.dependencies().stream().map(dependency -> this.getContributionExpression((DependencyRequest)dependency, requestingClass)).collect(XCodeBlocks.toParametersCodeBlock())).build());
        }
        switch (this.binding.dependencies().size()) {
            case 0: {
                return this.collectionsStaticFactoryInvocation(requestingClass, XCodeBlock.of("emptySet()", new Object[0]));
            }
            case 1: {
                DependencyRequest dependency2 = (DependencyRequest)Iterables.getOnlyElement(this.binding.dependencies());
                XCodeBlock contributionExpression = this.getContributionExpression(dependency2, requestingClass);
                if (this.isSingleValue(dependency2)) {
                    return this.collectionsStaticFactoryInvocation(requestingClass, XCodeBlock.of("singleton(%L)", contributionExpression));
                }
                if (!isImmutableSetAvailable) break;
                return XExpression.create(this.immutableSetType(), XCodeBlock.builder().add("%T.", XTypeNames.IMMUTABLE_SET).add(this.maybeTypeParameter(requestingClass)).add("copyOf(%L)", contributionExpression).build());
            }
        }
        String builderName = "setBuilder";
        XCodeBlock.Builder builderMethodCalls = XCodeBlock.builder();
        for (DependencyRequest dependency3 : this.binding.dependencies()) {
            String builderMethod = this.isSingleValue(dependency3) ? "add" : "addAll";
            builderMethodCalls.addStatement("%N.%N(%L)", builderName, builderMethod, this.getContributionExpression(dependency3, requestingClass));
        }
        String methodName = this.shard.getUniqueMethodName(KeyVariableNamer.name(this.binding.key()) + "Builder");
        XClassName returnType = isImmutableSetAvailable ? XTypeNames.IMMUTABLE_SET : XTypeNames.JAVA_UTIL_SET;
        XClassName builderType = isImmutableSetAvailable ? XTypeNames.IMMUTABLE_SET_BUILDER : XTypeNames.SET_BUILDER;
        XFunSpec methodSpec = XFunSpecs.methodBuilder(methodName).addModifiers((Collection<Modifier>)(!this.shard.isShardClassPrivate() ? ImmutableSet.of((Object)((Object)Modifier.PRIVATE)) : ImmutableSet.of())).returns(returnType).addCode(XCodeBlock.builder().addStatement("%T %N = %L", builderType, builderName, this.setBuilderInvocation(requestingClass, isImmutableSetAvailable)).add(builderMethodCalls.build()).addStatement("return %N.build()", builderName).build()).build();
        this.shard.addMethod(ComponentImplementation.MethodSpecKind.PRIVATE_METHOD, methodSpec);
        XType expressionType = isImmutableSetAvailable ? this.immutableSetType() : this.binding.key().type().xprocessing();
        boolean isSameClass = requestingClass.equals(this.shard.name());
        XCodeBlock codeBlock = isSameClass ? XCodeBlock.of("%N()", methodName) : XCodeBlock.of("%L.%N()", this.shard.shardFieldReference(), methodName);
        return XExpression.create(expressionType, codeBlock);
    }

    private XCodeBlock setBuilderInvocation(XClassName requestingClass, boolean isImmutableSetAvailable) {
        XCodeBlock.Builder builder = XCodeBlock.builder();
        XCodeBlock typeParam = this.maybeTypeParameter(requestingClass);
        if (isImmutableSetAvailable) {
            builder.add("%T.", XTypeNames.IMMUTABLE_SET).add(typeParam);
            if (this.isImmutableSetBuilderWithExpectedSizeAvailable()) {
                builder.add("builderWithExpectedSize(%L)", this.binding.dependencies().size());
            } else {
                builder.add("builder()", new Object[0]);
            }
        } else {
            builder.add("%T.", XTypeNames.SET_BUILDER).add(typeParam);
            builder.add("newSetBuilder(%L)", this.binding.dependencies().size());
        }
        return builder.build();
    }

    private XType immutableSetType() {
        return this.processingEnv.getDeclaredType(this.processingEnv.requireTypeElement(XTypeNames.IMMUTABLE_SET), SetType.from(this.binding.key()).elementType());
    }

    private XCodeBlock getContributionExpression(DependencyRequest dependency, XClassName requestingClass) {
        RequestRepresentation bindingExpression = this.componentRequestRepresentations.getRequestRepresentation(BindingRequest.bindingRequest(dependency));
        XCodeBlock expression = bindingExpression.getDependencyExpression(requestingClass).codeBlock();
        if (this.isSingleValue(dependency)) {
            return expression;
        }
        return !Accessibility.isTypeAccessibleFrom(this.binding.key().type().xprocessing(), requestingClass.getPackageName()) && (bindingExpression instanceof DerivedFromFrameworkInstanceRequestRepresentation || bindingExpression instanceof DelegateRequestRepresentation) ? XCodeBlocks.cast(expression, XTypeName.COLLECTION) : expression;
    }

    private XExpression collectionsStaticFactoryInvocation(XClassName requestingClass, XCodeBlock methodInvocation) {
        return XExpression.create(this.binding.key().type().xprocessing(), XCodeBlock.builder().add("%T.", XTypeNames.JAVA_UTIL_COLLECTIONS).add(this.maybeTypeParameter(requestingClass)).add(methodInvocation).build());
    }

    private XCodeBlock maybeTypeParameter(XClassName requestingClass) {
        XType elementType = SetType.from(this.binding.key()).elementType();
        return Accessibility.isTypeAccessibleFrom(elementType, requestingClass.getPackageName()) ? XCodeBlock.of("<%T>", elementType.asTypeName()) : XCodeBlock.of("", new Object[0]);
    }

    private boolean isSingleValue(DependencyRequest dependency) {
        return this.graph.contributionBinding(dependency.key()).contributionType().equals((Object)ContributionType.SET);
    }

    private boolean isImmutableSetBuilderWithExpectedSizeAvailable() {
        return this.isImmutableSetAvailable() && this.processingEnv.requireTypeElement(XTypeNames.IMMUTABLE_SET).getDeclaredMethods().stream().anyMatch(method -> XElements.getSimpleName(method).contentEquals("builderWithExpectedSize"));
    }

    private boolean isImmutableSetAvailable() {
        return this.processingEnv.findTypeElement(XTypeNames.IMMUTABLE_SET) != null;
    }

    @AssistedFactory
    static interface Factory {
        public SetRequestRepresentation create(MultiboundSetBinding var1);
    }
}

