/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import dagger.assisted.Assisted;
import dagger.assisted.AssistedFactory;
import dagger.assisted.AssistedInject;
import dagger.internal.codegen.binding.MembersInjectionBinding;
import dagger.internal.codegen.binding.MembersInjectorBinding;
import dagger.internal.codegen.binding.SourceFiles;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.internal.codegen.writing.ComponentRequestRepresentations;
import dagger.internal.codegen.writing.FrameworkFieldInitializer;
import dagger.internal.codegen.xprocessing.XTypeNames;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XType;
import dagger.spi.internal.shaded.androidx.room3.compiler.processing.XTypeElement;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Predicate;

final class MembersInjectorProviderCreationExpression
implements FrameworkFieldInitializer.FrameworkInstanceCreationExpression {
    private final ComponentImplementation.ShardImplementation shardImplementation;
    private final ComponentRequestRepresentations componentRequestRepresentations;
    private final MembersInjectorBinding binding;

    @AssistedInject
    MembersInjectorProviderCreationExpression(@Assisted MembersInjectorBinding binding, ComponentImplementation componentImplementation, ComponentRequestRepresentations componentRequestRepresentations) {
        this.binding = (MembersInjectorBinding)Preconditions.checkNotNull((Object)binding);
        this.shardImplementation = componentImplementation.shardImplementation(binding);
        this.componentRequestRepresentations = (ComponentRequestRepresentations)Preconditions.checkNotNull((Object)componentRequestRepresentations);
    }

    @Override
    public XCodeBlock creationExpression() {
        XCodeBlock membersInjector;
        XType membersInjectedType = (XType)Iterables.getOnlyElement(this.binding.key().type().xprocessing().getTypeArguments());
        boolean castThroughRawType = false;
        if (this.binding.injectionSites().isEmpty()) {
            membersInjector = XCodeBlock.of("%T.<%T>noOp()", XTypeNames.MEMBERS_INJECTORS, membersInjectedType.asTypeName());
        } else {
            XTypeElement injectedTypeElement = membersInjectedType.getTypeElement();
            while (!this.hasLocalInjectionSites(injectedTypeElement)) {
                castThroughRawType = true;
                injectedTypeElement = injectedTypeElement.getSuperType().getTypeElement();
            }
            membersInjector = XCodeBlock.of("%T.create(%L)", SourceFiles.membersInjectorNameForType(injectedTypeElement), this.componentRequestRepresentations.getCreateMethodArgumentsCodeBlock(this.binding, this.shardImplementation.name()));
        }
        XCodeBlock providerExpression = XCodeBlock.of("%T.create(%L)", XTypeNames.INSTANCE_FACTORY, membersInjector);
        return castThroughRawType ? XCodeBlock.ofCast(XTypeNames.INSTANCE_FACTORY, providerExpression) : providerExpression;
    }

    private boolean hasLocalInjectionSites(XTypeElement injectedTypeElement) {
        return this.binding.injectionSites().stream().map(MembersInjectionBinding.InjectionSite::enclosingTypeElement).anyMatch((Predicate<XTypeElement>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ldagger/spi/internal/shaded/androidx/room3/compiler/processing/XTypeElement;)Z)((XTypeElement)injectedTypeElement));
    }

    @AssistedFactory
    static interface Factory {
        public MembersInjectorProviderCreationExpression create(MembersInjectorBinding var1);
    }
}

