/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.writing;

import com.google.common.base.Preconditions;
import dagger.internal.codegen.writing.ComponentImplementation;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XClassName;
import dagger.spi.internal.shaded.androidx.room3.compiler.codegen.XCodeBlock;

abstract class MemberSelect {
    private final XClassName owningClass;
    private final boolean staticMember;

    static MemberSelect localField(ComponentImplementation.ShardImplementation owningShard, String fieldName) {
        return new LocalField(owningShard, fieldName);
    }

    MemberSelect(XClassName owningClass, boolean staticMemeber) {
        this.owningClass = owningClass;
        this.staticMember = staticMemeber;
    }

    XClassName owningClass() {
        return this.owningClass;
    }

    boolean staticMember() {
        return this.staticMember;
    }

    abstract XCodeBlock getExpressionFor(XClassName var1);

    private static final class LocalField
    extends MemberSelect {
        final ComponentImplementation.ShardImplementation owningShard;
        final String fieldName;

        LocalField(ComponentImplementation.ShardImplementation owningShard, String fieldName) {
            super(owningShard.name(), false);
            this.owningShard = owningShard;
            this.fieldName = (String)Preconditions.checkNotNull((Object)fieldName);
        }

        @Override
        XCodeBlock getExpressionFor(XClassName usingClass) {
            return this.owningClass().equals(usingClass) ? XCodeBlock.of("%N", this.fieldName) : XCodeBlock.of("%L.%N", this.owningShard.shardFieldReference(), this.fieldName);
        }
    }
}

